/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.peer;

import com.turn.ttorrent.client.PeerInformation;
import com.turn.ttorrent.client.Piece;
import com.turn.ttorrent.client.SharedTorrent;
import com.turn.ttorrent.client.peer.MessageListener;
import com.turn.ttorrent.client.peer.PeerActivityListener;
import com.turn.ttorrent.client.peer.Rate;
import com.turn.ttorrent.common.LoggerUtils;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.TorrentMetadata;
import com.turn.ttorrent.common.TorrentUtils;
import com.turn.ttorrent.common.protocol.PeerMessage;
import com.turn.ttorrent.network.ConnectionClosedException;
import com.turn.ttorrent.network.ConnectionManager;
import com.turn.ttorrent.network.WriteListener;
import com.turn.ttorrent.network.WriteTask;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SharingPeer
extends Peer
implements MessageListener,
PeerInformation {
    private static final Logger logger = TorrentLoggerFactory.getLogger(SharingPeer.class);
    private final Object availablePiecesLock;
    private volatile boolean choking;
    private volatile boolean interesting;
    private volatile boolean choked;
    private volatile boolean interested;
    private final SharedTorrent torrent;
    private final BitSet availablePieces;
    private BitSet poorlyAvailablePieces;
    private final Map<Piece, Integer> myRequestedPieces;
    private volatile boolean downloading;
    private final Rate download;
    private final Rate upload;
    private final AtomicInteger downloadedPiecesCount;
    private final List<PeerActivityListener> listeners;
    private final Object requestsLock;
    private final AtomicBoolean isStopped;
    private final ConnectionManager connectionManager;
    private final ByteChannel socketChannel;
    private final String clientIdentifier;
    private final int clientVersion;

    public SharingPeer(String ip, int port, ByteBuffer peerId, SharedTorrent torrent, ConnectionManager connectionManager, PeerActivityListener client, ByteChannel channel, String clientIdentifier, int clientVersion) {
        super(ip, port, peerId);
        this.torrent = torrent;
        this.clientIdentifier = clientIdentifier;
        this.clientVersion = clientVersion;
        this.listeners = Arrays.asList(client, torrent);
        this.availablePieces = new BitSet(torrent.getPieceCount());
        this.poorlyAvailablePieces = new BitSet(torrent.getPieceCount());
        this.requestsLock = new Object();
        this.socketChannel = channel;
        this.isStopped = new AtomicBoolean(false);
        this.availablePiecesLock = new Object();
        this.myRequestedPieces = new HashMap<Piece, Integer>();
        this.connectionManager = connectionManager;
        this.download = new Rate();
        this.upload = new Rate();
        this.setTorrentHash(torrent.getHexInfoHash());
        this.choking = true;
        this.interesting = false;
        this.choked = true;
        this.interested = false;
        this.downloading = false;
        this.downloadedPiecesCount = new AtomicInteger();
    }

    public Rate getDLRate() {
        return this.download;
    }

    public Rate getULRate() {
        return this.upload;
    }

    public void choke() {
        if (!this.choking) {
            logger.trace("Choking {}", (Object)this);
            this.send((PeerMessage)PeerMessage.ChokeMessage.craft());
            this.choking = true;
        }
    }

    @Override
    public byte[] getId() {
        return this.getPeerIdArray();
    }

    @Override
    public String getClientIdentifier() {
        return this.clientIdentifier;
    }

    @Override
    public int getClientVersion() {
        return this.clientVersion;
    }

    public void onConnectionEstablished() {
        this.firePeerConnected();
        BitSet pieces = this.torrent.getCompletedPieces();
        if (pieces.cardinality() > 0) {
            this.send((PeerMessage)PeerMessage.BitfieldMessage.craft((BitSet)pieces));
        }
        this.resetRates();
    }

    public void unchoke() {
        logger.trace("Unchoking {}", (Object)this);
        this.send((PeerMessage)PeerMessage.UnchokeMessage.craft());
        this.choking = false;
    }

    public boolean isChoking() {
        return this.choking;
    }

    public void interesting() {
        if (!this.interesting) {
            logger.trace("Telling {} we're interested.", (Object)this);
            this.send((PeerMessage)PeerMessage.InterestedMessage.craft());
            this.interesting = true;
        }
    }

    public void notInteresting() {
        if (this.interesting) {
            logger.trace("Telling {} we're no longer interested.", (Object)this);
            this.send((PeerMessage)PeerMessage.NotInterestedMessage.craft());
            this.interesting = false;
        }
    }

    public boolean isInteresting() {
        return this.interesting;
    }

    public boolean isChoked() {
        return this.choked;
    }

    public boolean isInterested() {
        return this.interested;
    }

    public BitSet getPoorlyAvailablePieces() {
        return this.poorlyAvailablePieces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet getAvailablePieces() {
        Object object = this.availablePiecesLock;
        synchronized (object) {
            return (BitSet)this.availablePieces.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Piece> getRequestedPieces() {
        Object object = this.requestsLock;
        synchronized (object) {
            return this.myRequestedPieces.keySet();
        }
    }

    public void resetRates() {
        this.download.reset();
        this.upload.reset();
    }

    public void pieceDownloaded() {
        this.downloadedPiecesCount.incrementAndGet();
    }

    public int getDownloadedPiecesCount() {
        return this.downloadedPiecesCount.get();
    }

    public boolean isConnected() {
        return this.socketChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(boolean force) {
        if (this.isStopped.getAndSet(true)) {
            return;
        }
        try {
            this.connectionManager.closeChannel((Channel)this.socketChannel);
        }
        catch (IOException e) {
            LoggerUtils.errorAndDebugDetails((Logger)logger, (String)"cannot close socket channel. Peer {}", (Object)this, (Throwable)e);
        }
        this.firePeerDisconnected();
        Object object = this.requestsLock;
        synchronized (object) {
            this.downloading = this.myRequestedPieces.size() > 0;
            this.myRequestedPieces.clear();
        }
        this.afterPeerDisconnected();
    }

    public void send(PeerMessage message) throws IllegalStateException {
        logger.trace("Sending msg {} to {}", (Object)message.getType(), (Object)this);
        if (this.isConnected()) {
            ByteBuffer data = message.getData();
            data.rewind();
            this.connectionManager.offerWrite(new WriteTask(this.socketChannel, data, new WriteListener(){

                public void onWriteFailed(String message, Throwable e) {
                    if (e == null) {
                        logger.info(message);
                    } else if (e instanceof ConnectionClosedException) {
                        logger.debug(message, e);
                        SharingPeer.this.unbind(true);
                    } else {
                        LoggerUtils.warnAndDebugDetails((Logger)logger, (String)message, (Throwable)e);
                    }
                }

                public void onWriteDone() {
                }
            }), 1, TimeUnit.SECONDS);
        } else {
            logger.trace("Attempting to send a message to non-connected peer {}!", (Object)this);
            this.unbind(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadPiece(Piece piece) throws IllegalStateException {
        ArrayList<PeerMessage.RequestMessage> toSend = new ArrayList<PeerMessage.RequestMessage>();
        Iterator iterator = this.requestsLock;
        synchronized (iterator) {
            if (this.myRequestedPieces.containsKey(piece)) {
                return;
            }
            int requestedBlocksCount = 0;
            int lastRequestedOffset = 0;
            while ((long)lastRequestedOffset < piece.size()) {
                PeerMessage.RequestMessage request = PeerMessage.RequestMessage.craft((int)piece.getIndex(), (int)lastRequestedOffset, (int)Math.min((int)(piece.size() - (long)lastRequestedOffset), 16384));
                toSend.add(request);
                ++requestedBlocksCount;
                lastRequestedOffset = request.getLength() + lastRequestedOffset;
            }
            this.myRequestedPieces.put(piece, requestedBlocksCount);
            this.downloading = this.myRequestedPieces.size() > 0;
        }
        for (PeerMessage.RequestMessage requestMessage : toSend) {
            this.send((PeerMessage)requestMessage);
        }
    }

    public boolean isDownloading() {
        return this.downloading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBlockRequest(Piece piece) {
        Object object = this.requestsLock;
        synchronized (object) {
            Integer requestedBlocksCount = this.myRequestedPieces.get(piece);
            if (requestedBlocksCount == null) {
                return;
            }
            if (requestedBlocksCount <= 1) {
                this.myRequestedPieces.remove(piece);
            } else {
                this.myRequestedPieces.put(piece, requestedBlocksCount - 1);
            }
            this.downloading = this.myRequestedPieces.size() > 0;
        }
    }

    public void cancelPendingRequests() {
        this.cancelPendingRequests(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPendingRequests(@Nullable Piece piece) {
        Object object = this.requestsLock;
        synchronized (object) {
            if (piece != null) {
                this.myRequestedPieces.remove(piece);
            } else {
                this.myRequestedPieces.clear();
            }
            this.downloading = this.myRequestedPieces.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemainingRequestedPieces(Piece piece) {
        Object object = this.requestsLock;
        synchronized (object) {
            Integer requestedBlocksCount = this.myRequestedPieces.get(piece);
            if (requestedBlocksCount == null) {
                return 0;
            }
            return requestedBlocksCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(PeerMessage msg) {
        if (this.isStopped.get()) {
            return;
        }
        if (!this.torrent.isInitialized()) {
            this.torrent.initIfNecessary(this);
        }
        switch (msg.getType()) {
            case KEEP_ALIVE: {
                break;
            }
            case CHOKE: {
                this.choked = true;
                this.firePeerChoked();
                this.cancelPendingRequests();
                break;
            }
            case UNCHOKE: {
                this.choked = false;
                logger.trace("Peer {} is now accepting requests.", (Object)this);
                this.firePeerReady();
                break;
            }
            case INTERESTED: {
                this.interested = true;
                if (!this.choking) break;
                this.unchoke();
                break;
            }
            case NOT_INTERESTED: {
                this.interested = false;
                if (this.interesting) break;
                this.unbind(true);
                break;
            }
            case HAVE: {
                PeerMessage.HaveMessage have = (PeerMessage.HaveMessage)msg;
                Piece havePiece = this.torrent.getPiece(have.getPieceIndex());
                Object object = this.availablePiecesLock;
                synchronized (object) {
                    this.availablePieces.set(havePiece.getIndex());
                    logger.trace("Peer {} now has {} [{}/{}].", new Object[]{this, havePiece, this.availablePieces.cardinality(), this.torrent.getPieceCount()});
                }
                this.firePieceAvailabity(havePiece);
                break;
            }
            case BITFIELD: {
                PeerMessage.BitfieldMessage bitfield = (PeerMessage.BitfieldMessage)msg;
                Object object = this.availablePiecesLock;
                synchronized (object) {
                    this.availablePieces.or(bitfield.getBitfield());
                    logger.trace("Recorded bitfield from {} with {} pieces(s) [{}/{}].", new Object[]{this, bitfield.getBitfield().cardinality(), this.availablePieces.cardinality(), this.torrent.getPieceCount()});
                }
                this.fireBitfieldAvailabity();
                break;
            }
            case REQUEST: {
                PeerMessage.RequestMessage request = (PeerMessage.RequestMessage)msg;
                logger.trace("Got request message for {} ({} {}@{}) from {}", new Object[]{Arrays.toString(TorrentUtils.getTorrentFileNames((TorrentMetadata)this.torrent).toArray()), request.getPiece(), request.getLength(), request.getOffset(), this});
                Piece rp = this.torrent.getPiece(request.getPiece());
                if (!rp.isValid()) {
                    logger.warn("Peer {} violated protocol, terminating exchange: " + this.isChoking() + " " + rp.isValid(), (Object)this);
                    this.unbind(true);
                    break;
                }
                if (request.getLength() > 131072) {
                    logger.warn("Peer {} requested a block too big, terminating exchange.", (Object)this);
                    this.unbind(true);
                    break;
                }
                try {
                    ByteBuffer bufferForMessage = PeerMessage.PieceMessage.createBufferWithHeaderForMessage((int)request.getPiece(), (int)request.getOffset(), (int)request.getLength());
                    rp.read(request.getOffset(), request.getLength(), bufferForMessage);
                    this.send((PeerMessage)PeerMessage.PieceMessage.craft((int)request.getPiece(), (int)request.getOffset(), (ByteBuffer)bufferForMessage));
                    this.upload.add(request.getLength());
                    if ((long)(request.getOffset() + request.getLength()) != rp.size()) break;
                    this.firePieceSent(rp);
                }
                catch (IOException ioe) {
                    logger.debug("error", (Throwable)ioe);
                    this.fireIOException(new IOException("Error while sending piece block request!", ioe));
                }
                break;
            }
            case PIECE: {
                PeerMessage.PieceMessage piece = (PeerMessage.PieceMessage)msg;
                Piece p = this.torrent.getPiece(piece.getPiece());
                logger.trace("Got piece ({} {}@{}) from {}", new Object[]{p.getIndex(), p.size(), piece.getOffset(), this});
                this.download.add(piece.getBlock().capacity());
                try {
                    boolean isPieceDownloaded = false;
                    Piece piece2 = p;
                    synchronized (piece2) {
                        this.removeBlockRequest(p);
                        if (p.isValid()) {
                            this.cancelPendingRequests(p);
                            this.firePeerReady();
                            logger.trace("Discarding block for already completed " + p);
                            break;
                        }
                        p.record(piece.getBlock(), piece.getOffset());
                        if (this.getRemainingRequestedPieces(p) == 0) {
                            this.firePieceCompleted(p);
                            isPieceDownloaded = true;
                        }
                    }
                    if (!isPieceDownloaded) break;
                    this.firePeerReady();
                }
                catch (IOException ioe) {
                    logger.error(ioe.getMessage(), (Throwable)ioe);
                    this.fireIOException(new IOException("Error while storing received piece block!", ioe));
                }
                break;
            }
        }
    }

    private void firePeerChoked() {
        for (PeerActivityListener listener : this.listeners) {
            listener.handlePeerChoked(this);
        }
    }

    private void firePeerReady() {
        for (PeerActivityListener listener : this.listeners) {
            listener.handlePeerReady(this);
        }
    }

    private void firePieceAvailabity(Piece piece) {
        for (PeerActivityListener listener : this.listeners) {
            listener.handlePieceAvailability(this, piece);
        }
    }

    private void fireBitfieldAvailabity() {
        for (PeerActivityListener listener : this.listeners) {
            listener.handleBitfieldAvailability(this, this.getAvailablePieces());
        }
    }

    private void firePieceSent(Piece piece) {
        for (PeerActivityListener listener : this.listeners) {
            listener.handlePieceSent(this, piece);
        }
    }

    private void firePieceCompleted(Piece piece) throws IOException {
        for (PeerActivityListener listener : this.listeners) {
            listener.handlePieceCompleted(this, piece);
        }
    }

    private void firePeerDisconnected() {
        for (PeerActivityListener listener : this.listeners) {
            listener.handlePeerDisconnected(this);
        }
    }

    private void afterPeerDisconnected() {
        for (PeerActivityListener listener : this.listeners) {
            listener.afterPeerRemoved(this);
        }
    }

    private void firePeerConnected() {
        for (PeerActivityListener listener : this.listeners) {
            listener.handleNewPeerConnected(this);
        }
    }

    private void fireIOException(IOException ioe) {
        for (PeerActivityListener listener : this.listeners) {
            listener.handleIOException(this, ioe);
        }
    }

    public SharedTorrent getTorrent() {
        return this.torrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadingPiecesCount() {
        Object object = this.requestsLock;
        synchronized (object) {
            return this.myRequestedPieces.size();
        }
    }

    public static class DLRateComparator
    implements Comparator<SharingPeer>,
    Serializable {
        private static final long serialVersionUID = 96307229964730L;

        @Override
        public int compare(SharingPeer a, SharingPeer b) {
            return Rate.RATE_COMPARATOR.compare(a.getDLRate(), b.getDLRate());
        }
    }
}

