/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.storage;

import com.turn.ttorrent.client.storage.TorrentByteStorage;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class FileStorage
implements TorrentByteStorage {
    private static final String PARTIAL_FILE_NAME_SUFFIX = ".part";
    private static final Logger logger = TorrentLoggerFactory.getLogger(FileStorage.class);
    private final File target;
    private File partial;
    private final long offset;
    private final long size;
    private RandomAccessFile raf;
    private FileChannel channel;
    private File current;
    private boolean myIsOpen = false;
    private boolean isBlank;
    private final ReadWriteLock myLock = new ReentrantReadWriteLock();

    public FileStorage(File file, long offset, long size) {
        this.target = file;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public void open(boolean seeder) throws IOException {
        try {
            this.myLock.writeLock().lock();
            if (seeder) {
                if (!this.target.exists()) {
                    throw new IOException("Target file " + this.target.getAbsolutePath() + " doesn't exist.");
                }
                this.current = this.target;
                this.raf = new RandomAccessFile(this.current, "r");
            } else {
                this.partial = new File(this.target.getAbsolutePath() + PARTIAL_FILE_NAME_SUFFIX);
                if (this.partial.exists()) {
                    logger.debug("Partial download found at {}. Continuing...", (Object)this.partial.getAbsolutePath());
                    this.current = this.partial;
                    this.isBlank = false;
                } else if (!this.target.exists()) {
                    logger.debug("Downloading new file to {}...", (Object)this.partial.getAbsolutePath());
                    this.current = this.partial;
                    this.isBlank = true;
                } else {
                    logger.debug("Using existing file {}.", (Object)this.target.getAbsolutePath());
                    this.current = this.target;
                    this.isBlank = false;
                }
                this.raf = new RandomAccessFile(this.current, "rw");
                this.raf.setLength(this.size);
            }
            this.myIsOpen = true;
            this.channel = this.raf.getChannel();
            logger.debug("Opened byte storage file at {} ({}+{} byte(s)).", new Object[]{this.current.getAbsolutePath(), this.offset, this.size});
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    protected long offset() {
        return this.offset;
    }

    public long size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer buffer, long position) throws IOException {
        try {
            this.myLock.readLock().lock();
            int requested = buffer.remaining();
            if (position + (long)requested > this.size) {
                throw new IllegalArgumentException("Invalid storage read request!");
            }
            int bytes = this.channel.read(buffer, position);
            if (bytes < requested) {
                throw new IOException("Storage underrun!");
            }
            int n = bytes;
            return n;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer buffer, long position) throws IOException {
        try {
            this.myLock.writeLock().lock();
            int requested = buffer.remaining();
            this.isBlank = false;
            if (position + (long)requested > this.size) {
                throw new IllegalArgumentException("Invalid storage write request!");
            }
            int n = this.channel.write(buffer, position);
            return n;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.myLock.writeLock().lock();
            if (!this.myIsOpen) {
                return;
            }
            logger.debug("Closing file channel to {}. Channel open: {}", (Object)this.current.getName(), (Object)this.channel.isOpen());
            if (this.channel.isOpen()) {
                try {
                    this.channel.force(true);
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                    // empty catch block
                }
            }
            this.raf.close();
            this.myIsOpen = false;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    @Override
    public void finish() throws IOException {
        try {
            this.myLock.writeLock().lock();
            logger.debug("Closing file channel to " + this.current.getName() + " (download complete).");
            if (this.channel.isOpen()) {
                this.channel.force(true);
            }
            if (this.isFinished()) {
                return;
            }
            try {
                FileUtils.deleteQuietly((File)this.target);
                this.raf.close();
                FileUtils.moveFile((File)this.current, (File)this.target);
            }
            catch (Exception ex) {
                logger.error("An error occurred while moving file to its final location", (Throwable)ex);
                if (this.target.exists()) {
                    throw new IOException("Was unable to delete existing file " + this.target.getAbsolutePath(), ex);
                }
                FileUtils.copyFile((File)this.current, (File)this.target);
            }
            this.current = this.target;
            FileUtils.deleteQuietly((File)this.partial);
            this.myIsOpen = false;
            logger.debug("Moved torrent data from {} to {}.", (Object)this.partial.getName(), (Object)this.target.getName());
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public boolean isOpen() {
        try {
            this.myLock.readLock().lock();
            boolean bl = this.myIsOpen;
            return bl;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    @Override
    public boolean isBlank(long position, long size) {
        return this.isBlank();
    }

    @Override
    public boolean isBlank() {
        try {
            this.myLock.readLock().lock();
            boolean bl = this.isBlank;
            return bl;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    @Override
    public boolean isFinished() {
        return this.current.equals(this.target);
    }

    @Override
    public void delete() throws IOException {
        this.close();
        File local = this.current;
        if (local != null) {
            local.delete();
        }
    }
}

