package bounty.controller;

import bounty.domain.Bounty;
import bounty.domain.BountySubmission;
import bounty.service.BountyService;
import bounty.service.BountySubmissionService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import java.util.List;

// 悬赏 Controller 类
@RestController
@RequestMapping("/bounties")
public class BountyController {
    @Autowired
    private BountyService bountyService;

    @PostMapping
    public ResponseEntity<?> saveBounty(@RequestBody Bounty bounty) {
        boolean result = bountyService.saveBounty(bounty);
        if (result) {
            return ResponseEntity.ok().build();
        } else {
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }
    @GetMapping
    // 导入 List 类
    public List<Bounty> getBounties() {  // 移除分页参数，返回 List 而非 IPage
        return bountyService.getBounties();  // 调用无分页的 Service 方法
    }

    @GetMapping("/{id}")
    public ResponseEntity<Bounty> getBountyById(@PathVariable Long id) {
        Bounty bounty = bountyService.getBountyById(id);
        System.out.println(bounty);
        if (bounty == null) {
            return ResponseEntity.notFound().build();
        } else {
            return ResponseEntity.ok(bounty);
        }
    }
    // 新增：发布悬赏接口
    @PostMapping("/publish")
    public boolean publishBounty(@RequestBody Bounty bounty) {
        return bountyService.publishBounty(bounty);
    }
}

