/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.cli;

import com.turn.ttorrent.common.TorrentCreator;
import com.turn.ttorrent.common.TorrentMetadata;
import com.turn.ttorrent.common.TorrentParser;
import com.turn.ttorrent.common.TorrentSerializer;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorrentMain {
    private static final Logger logger = LoggerFactory.getLogger(TorrentMain.class);

    private static void usage(PrintStream s) {
        TorrentMain.usage(s, null);
    }

    private static void usage(PrintStream s, String msg) {
        if (msg != null) {
            s.println(msg);
            s.println();
        }
        s.println("usage: Torrent [options] [file|directory]");
        s.println();
        s.println("Available options:");
        s.println("  -h,--help             Show this help and exit.");
        s.println("  -t,--torrent FILE     Use FILE to read/write torrent file.");
        s.println();
        s.println("  -c,--create           Create a new torrent file using the given announce URL and data.");
        s.println("  -l,--length           Define the piece length for hashing data");
        s.println("  -a,--announce         Tracker URL (can be repeated).");
        s.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        Integer pieceLengthVal;
        String filenameValue;
        BasicConfigurator.configure(new ConsoleAppender(new PatternLayout("%-5p: %m%n")));
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option help = parser.addBooleanOption('h', "help");
        CmdLineParser.Option filename = parser.addStringOption('t', "torrent");
        CmdLineParser.Option create = parser.addBooleanOption('c', "create");
        CmdLineParser.Option pieceLength = parser.addIntegerOption('l', "length");
        CmdLineParser.Option announce = parser.addStringOption('a', "announce");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException oe) {
            System.err.println(oe.getMessage());
            TorrentMain.usage(System.err);
            System.exit(1);
        }
        if (Boolean.TRUE.equals(parser.getOptionValue(help))) {
            TorrentMain.usage(System.out);
            System.exit(0);
        }
        if ((filenameValue = (String)parser.getOptionValue(filename)) == null) {
            TorrentMain.usage(System.err, "Torrent file must be provided!");
            System.exit(1);
        }
        pieceLengthVal = (pieceLengthVal = (Integer)parser.getOptionValue(pieceLength)) == null ? Integer.valueOf(524288) : Integer.valueOf(pieceLengthVal * 1024);
        logger.info("Using piece length of {} bytes.", pieceLengthVal);
        Boolean createFlag = (Boolean)parser.getOptionValue(create);
        Vector announceURLs = parser.getOptionValues(announce);
        String[] otherArgs = parser.getRemainingArgs();
        if (Boolean.TRUE.equals(createFlag) && (otherArgs.length != 1 || announceURLs.isEmpty())) {
            TorrentMain.usage(System.err, "Announce URL and a file or directory must be provided to create a torrent file!");
            System.exit(1);
        }
        FileOutputStream fos = null;
        try {
            if (Boolean.TRUE.equals(createFlag)) {
                TorrentMetadata torrent;
                fos = new FileOutputStream(filenameValue);
                ArrayList<URI> announceURIs = new ArrayList<URI>();
                for (String url : announceURLs) {
                    announceURIs.add(new URI(url));
                }
                ArrayList<List<URI>> announceList = new ArrayList<List<URI>>();
                announceList.add(announceURIs);
                File source = new File(otherArgs[0]);
                if (!source.exists() || !source.canRead()) {
                    throw new IllegalArgumentException("Cannot access source file or directory " + source.getName());
                }
                String creator = String.format("%s (ttorrent)", System.getProperty("user.name"));
                if (source.isDirectory()) {
                    ArrayList<File> files = new ArrayList<File>(FileUtils.listFiles(source, TrueFileFilter.TRUE, TrueFileFilter.TRUE));
                    Collections.sort(files);
                    torrent = TorrentCreator.create(source, files, (URI)((List)announceList.get(0)).get(0), announceList, creator, pieceLengthVal);
                } else {
                    torrent = TorrentCreator.create(source, null, (URI)((List)announceList.get(0)).get(0), announceList, creator, pieceLengthVal);
                }
                ((OutputStream)fos).write(new TorrentSerializer().serialize(torrent));
            } else {
                new TorrentParser().parseFromFile(new File(filenameValue));
            }
            if (fos == System.out) return;
        }
        catch (Exception e) {
            try {
                logger.error("{}", (Object)e.getMessage(), (Object)e);
                System.exit(2);
                if (fos == System.out) return;
            }
            catch (Throwable throwable) {
                if (fos == System.out) throw throwable;
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly(fos);
            return;
        }
        IOUtils.closeQuietly(fos);
        return;
    }
}

