/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client;

import com.turn.ttorrent.client.PieceInformation;
import com.turn.ttorrent.client.SharedTorrent;
import com.turn.ttorrent.client.peer.SharingPeer;
import com.turn.ttorrent.client.storage.PieceStorage;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.TorrentUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;

public class Piece
implements Comparable<Piece>,
PieceInformation {
    private static final Logger logger = TorrentLoggerFactory.getLogger(Piece.class);
    private final PieceStorage pieceStorage;
    private final int index;
    private final long length;
    private final byte[] hash;
    private volatile boolean valid;
    private int seen;
    private ByteBuffer data;

    public Piece(PieceStorage pieceStorage, int index, long length, byte[] hash) {
        this.pieceStorage = pieceStorage;
        this.index = index;
        this.length = length;
        this.hash = hash;
        this.valid = false;
        this.seen = 0;
        this.data = null;
    }

    @Override
    public int getSize() {
        return (int)this.length;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public long size() {
        return this.length;
    }

    public boolean available() {
        return this.seen > 0;
    }

    public void seenAt(SharingPeer peer) {
        ++this.seen;
    }

    public void noLongerAt(SharingPeer peer) {
        --this.seen;
    }

    void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean validate(SharedTorrent torrent, Piece piece) throws IOException {
        logger.trace("Validating {}...", this);
        byte[] pieceBytes = this.data.array();
        byte[] calculatedHash = TorrentUtils.calculateSha1Hash(pieceBytes);
        this.valid = Arrays.equals(calculatedHash, this.hash);
        logger.trace("validating result of piece {} is {}", this.index, (Object)this.valid);
        return this.isValid();
    }

    private ByteBuffer _read(long offset, long length, ByteBuffer buffer) throws IOException {
        if (offset + length > this.length) {
            throw new IllegalArgumentException("Piece#" + this.index + " overrun (" + offset + " + " + length + " > " + this.length + ") !");
        }
        int position = buffer.position();
        byte[] bytes = this.pieceStorage.readPiecePart(this.index, (int)offset, (int)length);
        buffer.put(bytes);
        buffer.rewind();
        buffer.limit(bytes.length + position);
        return buffer;
    }

    public ByteBuffer read(long offset, int length, ByteBuffer block) throws IllegalArgumentException, IllegalStateException, IOException {
        if (!this.valid) {
            throw new IllegalStateException("Attempting to read an known-to-be invalid piece!");
        }
        return this._read(offset, length, block);
    }

    public void record(ByteBuffer block, int offset) {
        if (this.data == null) {
            this.data = ByteBuffer.allocate((int)this.length);
        }
        int pos = block.position();
        this.data.position(offset);
        this.data.put(block);
        block.position(pos);
    }

    public void finish() throws IOException {
        this.data.rewind();
        logger.trace("Recording {}...", this);
        try {
            this.pieceStorage.savePiece(this.index, this.data.array());
        }
        finally {
            this.data = null;
        }
    }

    public String toString() {
        return String.format("piece#%4d%s", this.index, this.isValid() ? "+" : "-");
    }

    public boolean equals(Object obj) {
        if (obj instanceof Piece) {
            return this.index == ((Piece)obj).index;
        }
        return false;
    }

    @Override
    public int compareTo(Piece other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.seen == other.seen) {
            return new Integer(this.index).compareTo(other.index);
        }
        if (this.seen < other.seen) {
            return -1;
        }
        return 1;
    }
}

