/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.storage;

import com.turn.ttorrent.client.storage.FileStorage;
import com.turn.ttorrent.client.storage.TorrentByteStorage;
import com.turn.ttorrent.common.TorrentFile;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.TorrentMetadata;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class FileCollectionStorage
implements TorrentByteStorage {
    private static final Logger logger = TorrentLoggerFactory.getLogger(FileCollectionStorage.class);
    private final List<FileStorage> files;
    private final long size;
    private volatile boolean myIsOpen;

    public FileCollectionStorage(List<FileStorage> files, long size) {
        this.files = files;
        this.size = size;
        logger.debug("Initialized torrent byte storage on {} file(s) ({} total byte(s)).", files.size(), (Object)size);
    }

    public static FileCollectionStorage create(TorrentMetadata metadata, File parent) throws IOException {
        if (!parent.isDirectory()) {
            throw new IllegalArgumentException("Invalid parent directory!");
        }
        LinkedList<FileStorage> files = new LinkedList<FileStorage>();
        long offset = 0L;
        long totalSize = 0L;
        for (TorrentFile file : metadata.getFiles()) {
            File actual = new File(parent, file.getRelativePathAsString());
            if (!actual.getCanonicalPath().startsWith(parent.getCanonicalPath())) {
                throw new SecurityException("Torrent file path attempted to break directory jail!");
            }
            if (!actual.getParentFile().exists() && !actual.getParentFile().mkdirs()) {
                throw new IOException("Unable to create directories " + actual.getParent() + " for storing torrent file " + actual.getName());
            }
            files.add(new FileStorage(actual, offset, file.size));
            offset += file.size;
            totalSize += file.size;
        }
        return new FileCollectionStorage(files, totalSize);
    }

    @Override
    public synchronized void open(boolean seeder) throws IOException {
        for (FileStorage file : this.files) {
            if (file.isOpen()) continue;
            file.open(seeder);
        }
        this.myIsOpen = true;
    }

    @Override
    public int read(ByteBuffer buffer, long position) throws IOException {
        int requested = buffer.remaining();
        int bytes = 0;
        for (FileOffset fo : this.select(position, requested)) {
            buffer.limit((int)((long)buffer.position() + fo.length));
            bytes += fo.file.read(buffer, fo.offset);
        }
        if (bytes < requested) {
            throw new IOException("Storage collection read underrun!");
        }
        return bytes;
    }

    @Override
    public int write(ByteBuffer buffer, long position) throws IOException {
        int requested = buffer.remaining();
        int bytes = 0;
        for (FileOffset fo : this.select(position, requested)) {
            buffer.limit(bytes + (int)fo.length);
            bytes += fo.file.write(buffer, fo.offset);
        }
        if (bytes < requested) {
            throw new IOException("Storage collection write underrun!");
        }
        return bytes;
    }

    @Override
    public boolean isBlank(long position, long size) {
        for (FileOffset fo : this.select(position, size)) {
            if (fo.file.isBlank(fo.offset, fo.length)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isBlank() {
        for (FileStorage file : this.files) {
            if (file.isBlank()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() throws IOException {
        for (FileStorage file : this.files) {
            file.close();
        }
        this.myIsOpen = false;
    }

    @Override
    public synchronized void finish() throws IOException {
        for (FileStorage file : this.files) {
            file.finish();
        }
    }

    @Override
    public boolean isFinished() {
        for (FileStorage file : this.files) {
            if (file.isFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void delete() throws IOException {
        for (FileStorage file : this.files) {
            file.delete();
        }
    }

    private List<FileOffset> select(long offset, long length) {
        if (offset + length > this.size) {
            throw new IllegalArgumentException("Buffer overrun (" + offset + " + " + length + " > " + this.size + ") !");
        }
        LinkedList<FileOffset> selected = new LinkedList<FileOffset>();
        long bytes = 0L;
        for (FileStorage file : this.files) {
            if (file.offset() >= offset + length) break;
            if (file.offset() + file.size() < offset) continue;
            long position = offset - file.offset();
            position = position > 0L ? position : 0L;
            long size = Math.min(file.size() - position, length - bytes);
            selected.add(new FileOffset(file, position, size));
            bytes += size;
        }
        if (selected.size() == 0 || bytes < length) {
            throw new IllegalStateException("Buffer underrun (only got " + bytes + " out of " + length + " byte(s) requested)!");
        }
        return selected;
    }

    private static class FileOffset {
        public final FileStorage file;
        public final long offset;
        public final long length;

        FileOffset(FileStorage file, long offset, long length) {
            this.file = file;
            this.offset = offset;
            this.length = length;
        }
    }
}

