/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.creation.bytebuddy.MockAccess;
import org.mockito.internal.creation.bytebuddy.MockMethodDispatcher;
import org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.exceptions.stacktrace.ConditionalStackTraceFilter;
import org.mockito.internal.invocation.RealMethod;
import org.mockito.internal.invocation.SerializableMethod;
import org.mockito.internal.util.concurrent.WeakConcurrentMap;

public class MockMethodAdvice
extends MockMethodDispatcher {
    final WeakConcurrentMap<Object, MockMethodInterceptor> interceptors;
    private final String identifier;
    private final SelfCallInfo selfCallInfo = new SelfCallInfo();
    private final MethodGraph.Compiler compiler = MethodGraph.Compiler.Default.forJavaHierarchy();
    private final WeakConcurrentMap<Class<?>, SoftReference<MethodGraph>> graphs = new WeakConcurrentMap.WithInlinedExpunction();

    public MockMethodAdvice(WeakConcurrentMap<Object, MockMethodInterceptor> interceptors, String identifier) {
        this.interceptors = interceptors;
        this.identifier = identifier;
    }

    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    private static Callable<?> enter(@Identifier String identifier, @Advice.This Object mock, @Advice.Origin Method origin, @Advice.AllArguments Object[] arguments) throws Throwable {
        MockMethodDispatcher dispatcher = MockMethodDispatcher.get((String)identifier, (Object)mock);
        if (dispatcher == null || !dispatcher.isMocked(mock) || dispatcher.isOverridden(mock, origin)) {
            return null;
        }
        return dispatcher.handle(mock, origin, arguments);
    }

    @Advice.OnMethodExit
    private static void exit(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object returned, @Advice.Enter Callable<?> mocked) throws Throwable {
        if (mocked != null) {
            returned = mocked.call();
        }
    }

    static Throwable hideRecursiveCall(Throwable throwable, int current, Class<?> targetType) {
        try {
            StackTraceElement next;
            StackTraceElement[] stack = throwable.getStackTrace();
            int skip = 0;
            while (!(next = stack[stack.length - current - ++skip]).getClassName().equals(targetType.getName())) {
            }
            int top = stack.length - current - skip;
            StackTraceElement[] cleared = new StackTraceElement[stack.length - skip];
            System.arraycopy(stack, 0, cleared, 0, top);
            System.arraycopy(stack, top + skip, cleared, top, current);
            throwable.setStackTrace(cleared);
            return throwable;
        }
        catch (RuntimeException ignored) {
            return throwable;
        }
    }

    public Callable<?> handle(Object instance, Method origin, Object[] arguments) throws Throwable {
        MockMethodInterceptor interceptor = this.interceptors.get(instance);
        if (interceptor == null) {
            return null;
        }
        RealMethod realMethod = instance instanceof Serializable ? new SerializableRealMethodCall(this.identifier, origin, instance, arguments) : new RealMethodCall(this.selfCallInfo, origin, instance, arguments);
        Throwable t = new Throwable();
        t.setStackTrace(MockMethodAdvice.skipInlineMethodElement(t.getStackTrace()));
        return new ReturnValueWrapper(interceptor.doIntercept(instance, origin, arguments, realMethod, new LocationImpl(t)));
    }

    public boolean isMock(Object instance) {
        return this.interceptors.containsKey(instance);
    }

    public boolean isMocked(Object instance) {
        return !this.selfCallInfo.isSelfInvocation(instance) && this.isMock(instance);
    }

    public boolean isOverridden(Object instance, Method origin) {
        MethodGraph.Node node;
        MethodGraph methodGraph;
        SoftReference<MethodGraph> reference = this.graphs.get(instance.getClass());
        MethodGraph methodGraph2 = methodGraph = reference == null ? null : reference.get();
        if (methodGraph == null) {
            methodGraph = this.compiler.compile(new TypeDescription.ForLoadedType(instance.getClass()));
            this.graphs.put(instance.getClass(), new SoftReference<MethodGraph>(methodGraph));
        }
        return !(node = methodGraph.locate(new MethodDescription.ForLoadedMethod(origin).asSignatureToken())).getSort().isResolved() || !((MethodDescription.InDefinedShape)node.getRepresentative().asDefined()).getDeclaringType().represents(origin.getDeclaringClass());
    }

    private static Object tryInvoke(Method origin, Object instance, Object[] arguments) throws Throwable {
        try {
            return origin.invoke(instance, arguments);
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            new ConditionalStackTraceFilter().filter(MockMethodAdvice.hideRecursiveCall(cause, new Throwable().getStackTrace().length, origin.getDeclaringClass()));
            throw cause;
        }
    }

    private static StackTraceElement[] skipInlineMethodElement(StackTraceElement[] elements) {
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            list.add(element);
            if (!element.getClassName().equals(MockMethodAdvice.class.getName()) || !element.getMethodName().equals("handle")) continue;
            ++i;
        }
        return list.toArray(new StackTraceElement[list.size()]);
    }

    public static class ForReadObject {
        public static void doReadObject(@Identifier String identifier, @This MockAccess thiz, @Argument(value=0) ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            MockMethodAdvice mockMethodAdvice = (MockMethodAdvice)MockMethodDispatcher.get((String)identifier, (Object)thiz);
            if (mockMethodAdvice != null) {
                mockMethodAdvice.interceptors.put(thiz, thiz.getMockitoInterceptor());
            }
        }
    }

    static class ForEquals {
        ForEquals() {
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        private static boolean enter(@Identifier String identifier, @Advice.This Object self) {
            MockMethodDispatcher dispatcher = MockMethodDispatcher.get((String)identifier, (Object)self);
            return dispatcher != null && dispatcher.isMock(self);
        }

        @Advice.OnMethodExit
        private static void enter(@Advice.This Object self, @Advice.Argument(value=0) Object other, @Advice.Return(readOnly=false) boolean equals, @Advice.Enter boolean skipped) {
            if (skipped) {
                equals = self == other;
            }
        }
    }

    static class ForHashCode {
        ForHashCode() {
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        private static boolean enter(@Identifier String id, @Advice.This Object self) {
            MockMethodDispatcher dispatcher = MockMethodDispatcher.get((String)id, (Object)self);
            return dispatcher != null && dispatcher.isMock(self);
        }

        @Advice.OnMethodExit
        private static void enter(@Advice.This Object self, @Advice.Return(readOnly=false) int hashCode, @Advice.Enter boolean skipped) {
            if (skipped) {
                hashCode = System.identityHashCode(self);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Identifier {
    }

    private static class SelfCallInfo
    extends ThreadLocal<Object> {
        private SelfCallInfo() {
        }

        Object replace(Object instance) {
            Object current = this.get();
            this.set(instance);
            return current;
        }

        boolean isSelfInvocation(Object instance) {
            return this.get() == instance;
        }
    }

    private static class ReturnValueWrapper
    implements Callable<Object> {
        private final Object returned;

        private ReturnValueWrapper(Object returned) {
            this.returned = returned;
        }

        @Override
        public Object call() {
            return this.returned;
        }
    }

    private static class SerializableRealMethodCall
    implements RealMethod {
        private final String identifier;
        private final SerializableMethod origin;
        private final Object instance;
        private final Object[] arguments;

        private SerializableRealMethodCall(String identifier, Method origin, Object instance, Object[] arguments) {
            this.origin = new SerializableMethod(origin);
            this.identifier = identifier;
            this.instance = instance;
            this.arguments = arguments;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke() throws Throwable {
            MockMethodDispatcher mockMethodDispatcher;
            Method method = this.origin.getJavaMethod();
            if (!Modifier.isPublic(method.getDeclaringClass().getModifiers() & method.getModifiers())) {
                method.setAccessible(true);
            }
            if (!((mockMethodDispatcher = MockMethodDispatcher.get((String)this.identifier, (Object)this.instance)) instanceof MockMethodAdvice)) {
                throw new MockitoException("Unexpected dispatcher for advice-based super call");
            }
            Object previous = ((MockMethodAdvice)mockMethodDispatcher).selfCallInfo.replace(this.instance);
            try {
                Object object = MockMethodAdvice.tryInvoke(method, this.instance, this.arguments);
                return object;
            }
            finally {
                ((MockMethodAdvice)mockMethodDispatcher).selfCallInfo.set(previous);
            }
        }
    }

    private static class RealMethodCall
    implements RealMethod {
        private final SelfCallInfo selfCallInfo;
        private final Method origin;
        private final Object instance;
        private final Object[] arguments;

        private RealMethodCall(SelfCallInfo selfCallInfo, Method origin, Object instance, Object[] arguments) {
            this.selfCallInfo = selfCallInfo;
            this.origin = origin;
            this.instance = instance;
            this.arguments = arguments;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke() throws Throwable {
            if (!Modifier.isPublic(this.origin.getDeclaringClass().getModifiers() & this.origin.getModifiers())) {
                this.origin.setAccessible(true);
            }
            Object previous = this.selfCallInfo.replace(this.instance);
            try {
                Object object = MockMethodAdvice.tryInvoke(this.origin, this.instance, this.arguments);
                return object;
            }
            finally {
                this.selfCallInfo.set(previous);
            }
        }
    }
}

