/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client;

import com.turn.ttorrent.client.LoadedTorrent;
import com.turn.ttorrent.client.SharedTorrent;
import com.turn.ttorrent.common.AnnounceableInformation;
import com.turn.ttorrent.common.Pair;
import com.turn.ttorrent.common.TorrentUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TorrentsStorage {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<String, SharedTorrent> activeTorrents = new HashMap<String, SharedTorrent>();
    private final Map<String, LoadedTorrent> loadedTorrents = new HashMap<String, LoadedTorrent>();

    public boolean hasTorrent(String hash) {
        try {
            this.readWriteLock.readLock().lock();
            boolean bl = this.loadedTorrents.containsKey(hash);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public LoadedTorrent getLoadedTorrent(String hash) {
        try {
            this.readWriteLock.readLock().lock();
            LoadedTorrent loadedTorrent = this.loadedTorrents.get(hash);
            return loadedTorrent;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerDisconnected(String torrentHash) {
        SharedTorrent torrent;
        block6: {
            try {
                this.readWriteLock.writeLock().lock();
                torrent = this.activeTorrents.get(torrentHash);
                if (torrent == null) {
                    return;
                }
                boolean isTorrentFinished = torrent.isFinished();
                if (torrent.getDownloadersCount() == 0 && isTorrentFinished) {
                    this.activeTorrents.remove(torrentHash);
                    break block6;
                }
                return;
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        torrent.close();
    }

    public SharedTorrent getTorrent(String hash) {
        try {
            this.readWriteLock.readLock().lock();
            SharedTorrent sharedTorrent = this.activeTorrents.get(hash);
            return sharedTorrent;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void addTorrent(String hash, LoadedTorrent torrent) {
        try {
            this.readWriteLock.writeLock().lock();
            this.loadedTorrents.put(hash, torrent);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedTorrent putIfAbsentActiveTorrent(String hash, SharedTorrent torrent) {
        try {
            this.readWriteLock.writeLock().lock();
            SharedTorrent old = this.activeTorrents.get(hash);
            if (old != null) {
                SharedTorrent sharedTorrent = old;
                return sharedTorrent;
            }
            SharedTorrent sharedTorrent = this.activeTorrents.put(hash, torrent);
            return sharedTorrent;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<SharedTorrent, LoadedTorrent> remove(String hash) {
        Pair result;
        try {
            this.readWriteLock.writeLock().lock();
            SharedTorrent sharedTorrent = this.activeTorrents.remove(hash);
            LoadedTorrent loadedTorrent = this.loadedTorrents.remove(hash);
            result = new Pair((Object)sharedTorrent, (Object)loadedTorrent);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        if (result.second() != null) {
            try {
                ((LoadedTorrent)result.second()).getPieceStorage().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (result.first() != null) {
            ((SharedTorrent)result.first()).closeFully();
        }
        return result;
    }

    public List<SharedTorrent> activeTorrents() {
        try {
            this.readWriteLock.readLock().lock();
            ArrayList<SharedTorrent> arrayList = new ArrayList<SharedTorrent>(this.activeTorrents.values());
            return arrayList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnnounceableInformation> announceableTorrents() {
        ArrayList<AnnounceableInformation> result = new ArrayList<AnnounceableInformation>();
        try {
            this.readWriteLock.readLock().lock();
            for (LoadedTorrent loadedTorrent : this.loadedTorrents.values()) {
                AnnounceableInformation announceableInformation = loadedTorrent.createAnnounceableInformation();
                if (TorrentUtils.isTrackerLessInfo((AnnounceableInformation)announceableInformation)) continue;
                result.add(announceableInformation);
            }
            ArrayList<AnnounceableInformation> arrayList = result;
            return arrayList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public List<LoadedTorrent> getLoadedTorrents() {
        try {
            this.readWriteLock.readLock().lock();
            ArrayList<LoadedTorrent> arrayList = new ArrayList<LoadedTorrent>(this.loadedTorrents.values());
            return arrayList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void clear() {
        ArrayList<LoadedTorrent> loadedTorrents;
        ArrayList<SharedTorrent> sharedTorrents;
        try {
            this.readWriteLock.writeLock().lock();
            sharedTorrents = new ArrayList<SharedTorrent>(this.activeTorrents.values());
            loadedTorrents = new ArrayList<LoadedTorrent>(this.loadedTorrents.values());
            this.loadedTorrents.clear();
            this.activeTorrents.clear();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        for (SharedTorrent sharedTorrent : sharedTorrents) {
            sharedTorrent.closeFully();
        }
        for (LoadedTorrent loadedTorrent : loadedTorrents) {
            try {
                loadedTorrent.getPieceStorage().close();
            }
            catch (IOException iOException) {}
        }
    }
}

