/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.creation;

import com.turn.ttorrent.common.TorrentUtils;
import com.turn.ttorrent.common.creation.CommonHashingCalculator;
import com.turn.ttorrent.common.creation.DataSourceHolder;
import com.turn.ttorrent.common.creation.HashingResult;
import com.turn.ttorrent.common.creation.PiecesHashesCalculator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class MultiThreadHashesCalculator
implements PiecesHashesCalculator {
    private final ExecutorService executor;
    private final int maxInMemoryPieces;

    public MultiThreadHashesCalculator(ExecutorService executor, int maxInMemoryPieces) {
        this.executor = executor;
        this.maxInMemoryPieces = maxInMemoryPieces;
    }

    @Override
    public HashingResult calculateHashes(List<DataSourceHolder> sources, int pieceSize) throws IOException {
        final ArrayList<byte[]> hashes = new ArrayList<byte[]>();
        final ArrayList<Future<byte[]>> futures = new ArrayList<Future<byte[]>>();
        List<Long> sourcesSizes = CommonHashingCalculator.INSTANCE.processDataSources(sources, pieceSize, new CommonHashingCalculator.Processor(){

            @Override
            public void process(byte[] buffer) {
                MultiThreadHashesCalculator.this.awaitHashesCalculationAndStore(futures, hashes, MultiThreadHashesCalculator.this.maxInMemoryPieces);
                final byte[] bufferCopy = Arrays.copyOf(buffer, buffer.length);
                futures.add(MultiThreadHashesCalculator.this.executor.submit(new Callable<byte[]>(){

                    @Override
                    public byte[] call() {
                        return TorrentUtils.calculateSha1Hash(bufferCopy);
                    }
                }));
            }
        });
        this.awaitHashesCalculationAndStore(futures, hashes, 0);
        return new HashingResult(hashes, sourcesSizes);
    }

    private void awaitHashesCalculationAndStore(List<Future<byte[]>> futures, List<byte[]> hashes, int count) {
        while (futures.size() > count) {
            byte[] hash;
            try {
                Future<byte[]> future = futures.remove(0);
                hash = future.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            hashes.add(hash);
        }
    }
}

