/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.network.keyProcessors;

import com.turn.ttorrent.common.TimeService;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.network.AcceptAttachment;
import com.turn.ttorrent.network.ChannelListenerFactory;
import com.turn.ttorrent.network.ConnectionListener;
import com.turn.ttorrent.network.NewConnectionAllower;
import com.turn.ttorrent.network.ReadWriteAttachment;
import com.turn.ttorrent.network.TimeoutStorage;
import com.turn.ttorrent.network.keyProcessors.KeyProcessor;
import com.turn.ttorrent.network.keyProcessors.KeyProcessorUtil;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class AcceptableKeyProcessor
implements KeyProcessor {
    private static final Logger logger = TorrentLoggerFactory.getLogger(AcceptableKeyProcessor.class);
    private final Selector mySelector;
    private final String myServerSocketLocalAddress;
    private final TimeService myTimeService;
    private final NewConnectionAllower myNewConnectionAllower;
    private final TimeoutStorage myTimeoutStorage;
    private final AtomicInteger mySendBufferSize;
    private final AtomicInteger myReceiveBufferSize;

    public AcceptableKeyProcessor(Selector selector, String serverSocketLocalAddress, TimeService timeService, NewConnectionAllower newConnectionAllower, TimeoutStorage timeoutStorage, AtomicInteger sendBufferSize, AtomicInteger receiveBufferSize) {
        this.mySelector = selector;
        this.myServerSocketLocalAddress = serverSocketLocalAddress;
        this.myTimeService = timeService;
        this.myNewConnectionAllower = newConnectionAllower;
        this.myTimeoutStorage = timeoutStorage;
        this.mySendBufferSize = sendBufferSize;
        this.myReceiveBufferSize = receiveBufferSize;
    }

    @Override
    public void process(SelectionKey key) throws IOException {
        SelectableChannel channel = key.channel();
        if (!(channel instanceof ServerSocketChannel)) {
            logger.error("incorrect instance of server channel. Can not accept connections");
            key.cancel();
            return;
        }
        Object attachment = key.attachment();
        if (!(attachment instanceof AcceptAttachment)) {
            logger.error("incorrect instance of server channel key attachment");
            key.cancel();
            return;
        }
        ChannelListenerFactory channelListenerFactory = ((AcceptAttachment)attachment).getChannelListenerFactory();
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        logger.trace("server {} get new connection from {}", new Object[]{this.myServerSocketLocalAddress, socketChannel.socket()});
        if (!this.myNewConnectionAllower.isNewConnectionAllowed()) {
            logger.info("new connection is not allowed. New connection is closed");
            socketChannel.close();
            return;
        }
        ConnectionListener stateConnectionListener = channelListenerFactory.newChannelListener();
        stateConnectionListener.onConnectionEstablished(socketChannel);
        socketChannel.configureBlocking(false);
        KeyProcessorUtil.setBuffersSizeIfNecessary(socketChannel, this.mySendBufferSize.get(), this.myReceiveBufferSize.get());
        ReadWriteAttachment keyAttachment = new ReadWriteAttachment(stateConnectionListener, this.myTimeService.now(), this.myTimeoutStorage.getTimeoutMillis());
        socketChannel.register(this.mySelector, 1, keyAttachment);
    }

    @Override
    public boolean accept(SelectionKey key) {
        return key.isValid() && key.isAcceptable();
    }
}

