/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.network;

import com.turn.ttorrent.client.Context;
import com.turn.ttorrent.client.PeersStorage;
import com.turn.ttorrent.client.network.DataProcessor;
import com.turn.ttorrent.client.network.DataProcessorUtil;
import com.turn.ttorrent.client.peer.SharingPeer;
import com.turn.ttorrent.common.PeerUID;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import org.slf4j.Logger;

public class ShutdownAndRemovePeerProcessor
implements DataProcessor {
    private static final Logger logger = TorrentLoggerFactory.getLogger(ShutdownAndRemovePeerProcessor.class);
    private final PeerUID myPeerUID;
    private final Context myContext;

    public ShutdownAndRemovePeerProcessor(PeerUID peerId, Context context) {
        this.myPeerUID = peerId;
        this.myContext = context;
    }

    @Override
    public DataProcessor processAndGetNext(ByteChannel socketChannel) throws IOException {
        DataProcessorUtil.closeChannelIfOpen(logger, socketChannel);
        logger.trace("try remove and unbind peer. Peer UID - {}", this.myPeerUID);
        this.removePeer();
        return null;
    }

    private void removePeer() {
        PeersStorage peersStorage = this.myContext.getPeersStorage();
        SharingPeer removedPeer = peersStorage.removeSharingPeer(this.myPeerUID);
        if (removedPeer == null) {
            logger.info("try to shutdown peer with id {}, but it is not found in storage", this.myPeerUID);
            return;
        }
        removedPeer.unbind(true);
    }

    @Override
    public DataProcessor handleError(ByteChannel socketChannel, Throwable e) throws IOException {
        return this.processAndGetNext(socketChannel);
    }
}

