/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.protocol.http;

import com.turn.ttorrent.bcodec.BDecoder;
import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import com.turn.ttorrent.common.protocol.http.HTTPAnnounceRequestMessage;
import com.turn.ttorrent.common.protocol.http.HTTPAnnounceResponseMessage;
import com.turn.ttorrent.common.protocol.http.HTTPTrackerErrorMessage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public abstract class HTTPTrackerMessage
extends TrackerMessage {
    protected HTTPTrackerMessage(TrackerMessage.Type type, ByteBuffer data) {
        super(type, data);
    }

    public static HTTPTrackerMessage parse(InputStream data) throws IOException, TrackerMessage.MessageValidationException {
        BEValue decoded = BDecoder.bdecode(data);
        if (decoded == null) {
            throw new TrackerMessage.MessageValidationException("Could not decode tracker message (not B-encoded?)!: ");
        }
        return HTTPTrackerMessage.parse(decoded);
    }

    public static HTTPTrackerMessage parse(BEValue decoded) throws IOException, TrackerMessage.MessageValidationException {
        Map<String, BEValue> params = decoded.getMap();
        if (params.containsKey("info_hash")) {
            return HTTPAnnounceRequestMessage.parse(decoded);
        }
        if (params.containsKey("peers")) {
            return HTTPAnnounceResponseMessage.parse(decoded);
        }
        if (params.containsKey("failure reason")) {
            return HTTPTrackerErrorMessage.parse(decoded);
        }
        throw new TrackerMessage.MessageValidationException("Unknown HTTP tracker message!");
    }
}

