/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.tracker;

import com.turn.ttorrent.common.LoggerUtils;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.tracker.MultiAnnounceRequestProcessor;
import com.turn.ttorrent.tracker.TrackerRequestProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.io.IOUtils;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.slf4j.Logger;

public class TrackerServiceContainer
implements Container {
    private static final Logger logger = TorrentLoggerFactory.getLogger(TrackerServiceContainer.class);
    private TrackerRequestProcessor myRequestProcessor;
    private final MultiAnnounceRequestProcessor myMultiAnnounceRequestProcessor;

    public TrackerServiceContainer(TrackerRequestProcessor requestProcessor, MultiAnnounceRequestProcessor multiAnnounceRequestProcessor) {
        this.myRequestProcessor = requestProcessor;
        this.myMultiAnnounceRequestProcessor = multiAnnounceRequestProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Request request, Response response) {
        if (!"/announce".equals(request.getPath().toString())) {
            response.setCode(404);
            response.setText("Not Found");
            return;
        }
        OutputStream body = null;
        try {
            body = response.getOutputStream();
            response.set("Content-Type", "text/plain");
            response.set("Server", "");
            response.setDate("Date", System.currentTimeMillis());
            if ("GET".equalsIgnoreCase(request.getMethod())) {
                this.myRequestProcessor.process(request.getAddress().toString(), request.getClientAddress().getAddress().getHostAddress(), this.getRequestHandler(response));
            } else {
                this.myMultiAnnounceRequestProcessor.process(request.getContent(), request.getAddress().toString(), request.getClientAddress().getAddress().getHostAddress(), this.getRequestHandler(response));
            }
            body.flush();
        }
        catch (IOException ioe) {
            logger.info("Error while writing response: {}!", (Object)ioe.getMessage());
        }
        catch (Throwable t) {
            LoggerUtils.errorAndDebugDetails(logger, "error in processing request {}", request, t);
        }
        finally {
            IOUtils.closeQuietly(body);
        }
    }

    private TrackerRequestProcessor.RequestHandler getRequestHandler(final Response response) {
        return new TrackerRequestProcessor.RequestHandler(){

            @Override
            public void serveResponse(int code, String description, ByteBuffer responseData) {
                response.setCode(code);
                response.setText(description);
                try {
                    responseData.rewind();
                    WritableByteChannel channel = Channels.newChannel(response.getOutputStream());
                    channel.write(responseData);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public void setAcceptForeignTorrents(boolean acceptForeignTorrents) {
        this.myRequestProcessor.setAcceptForeignTorrents(acceptForeignTorrents);
    }

    public void setAnnounceInterval(int announceInterval) {
        this.myRequestProcessor.setAnnounceInterval(announceInterval);
    }
}

