/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common.creation;

import com.turn.ttorrent.common.TorrentUtils;
import com.turn.ttorrent.common.creation.CommonHashingCalculator;
import com.turn.ttorrent.common.creation.DataSourceHolder;
import com.turn.ttorrent.common.creation.HashingResult;
import com.turn.ttorrent.common.creation.PiecesHashesCalculator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SingleThreadHashesCalculator
implements PiecesHashesCalculator {
    @Override
    public HashingResult calculateHashes(List<DataSourceHolder> sources, int pieceSize) throws IOException {
        final ArrayList<byte[]> hashes = new ArrayList<byte[]>();
        List<Long> sourcesSizes = CommonHashingCalculator.INSTANCE.processDataSources(sources, pieceSize, new CommonHashingCalculator.Processor(){

            @Override
            public void process(byte[] buffer) {
                byte[] hash = TorrentUtils.calculateSha1Hash(buffer);
                hashes.add(hash);
            }
        });
        return new HashingResult(hashes, sourcesSizes);
    }
}

