package bounty.mapper;

import bounty.domain.BountySubmission;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;

import java.util.List;
import java.util.Map;

// 悬赏提交 Mapper 接口
@Mapper
public interface BountySubmissionMapper extends BaseMapper<BountySubmission> {
    // 与 XML 中 id="getBountySubmissionsByPage" 的 SQL 匹配
    IPage<BountySubmission> getBountySubmissionsByPage(Page<BountySubmission> page, @Param("bountyId") Long bountyId);
    // 导入 List 类
    List<BountySubmission> getSubmissionsByBountyId(@Param("bountyId") Long bountyId);
}


