package com.ruoyi;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;

/**
 * 启动程序
 * 
 * @author ruoyi
 */
@ComponentScan(basePackages = {
        "com.ruoyi",
        "bounty"  // 新增您的包路径
})
// 关键添加：扩大MyBatis接口扫描范围
@MapperScan(basePackages = {
        "com.ruoyi.**.mapper",
        "bounty.mapper"  // 如果bounty下有Mapper接口
})

@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class })
public class RuoYiApplication {
    public static void main(String[] args) {
        // System.setProperty("spring.devtools.restart.enabled", "false");
        SpringApplication.run(RuoYiApplication.class, args);
        // ANSI escape code for blue text
        String blue = "\u001B[34m";
        // ANSI escape code to reset text color
        String reset = "\u001B[0m";

        System.out.println(blue + " ----贾仁翔 喵喵喵" + reset);
    }
}
