package com.ruoyi.web.controller.post.domain;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.annotation.Excel.ColumnType;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 帖子评论表 sys_post_comment
 * 
 * @author thunderhub
 */
public class PostComment extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 评论ID */
    @Excel(name = "评论ID", cellType = ColumnType.NUMERIC)
    private Long commentId;

    /** 帖子ID */
    @Excel(name = "帖子ID")
    private Long postId;

    /** 评论内容 */
    @Excel(name = "评论内容")
    private String content;

    /** 评论人ID */
    @Excel(name = "评论人ID")
    private Long userId;

    /** 评论人名称 */
    @Excel(name = "评论人名称")
    private String userName;

    /** 评论人头像 */
    private String userAvatar;

    /** 父评论ID，如果为0则为顶级评论 */
    private Long parentId;

    /** 回复对象的用户ID */
    private Long replyUserId;

    /** 回复对象的用户名称 */
    private String replyUserName;

    /** 状态（0待审核 1正常 2拒绝） */
    @Excel(name = "状态", readConverterExp = "0=待审核,1=正常,2=拒绝")
    private String status;

    /** 点赞数 */
    @Excel(name = "点赞数")
    private Long likes;

    public Long getCommentId()
    {
        return commentId;
    }

    public void setCommentId(Long commentId)
    {
        this.commentId = commentId;
    }

    public Long getPostId()
    {
        return postId;
    }

    public void setPostId(Long postId)
    {
        this.postId = postId;
    }

    @NotBlank(message = "评论内容不能为空")
    @Size(min = 0, max = 500, message = "评论内容长度不能超过500个字符")
    public String getContent()
    {
        return content;
    }

    public void setContent(String content)
    {
        this.content = content;
    }

    public Long getUserId()
    {
        return userId;
    }

    public void setUserId(Long userId)
    {
        this.userId = userId;
    }

    public String getUserName()
    {
        return userName;
    }

    public void setUserName(String userName)
    {
        this.userName = userName;
    }

    public String getUserAvatar()
    {
        return userAvatar;
    }

    public void setUserAvatar(String userAvatar)
    {
        this.userAvatar = userAvatar;
    }

    public Long getParentId()
    {
        return parentId;
    }

    public void setParentId(Long parentId)
    {
        this.parentId = parentId;
    }

    public Long getReplyUserId()
    {
        return replyUserId;
    }

    public void setReplyUserId(Long replyUserId)
    {
        this.replyUserId = replyUserId;
    }

    public String getReplyUserName()
    {
        return replyUserName;
    }

    public void setReplyUserName(String replyUserName)
    {
        this.replyUserName = replyUserName;
    }

    public String getStatus()
    {
        return status;
    }

    public void setStatus(String status)
    {
        this.status = status;
    }

    public Long getLikes()
    {
        return likes;
    }

    public void setLikes(Long likes)
    {
        this.likes = likes;
    }
    
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
            .append("commentId", getCommentId())
            .append("postId", getPostId())
            .append("content", getContent())
            .append("userId", getUserId())
            .append("userName", getUserName())
            .append("userAvatar", getUserAvatar())
            .append("parentId", getParentId())
            .append("replyUserId", getReplyUserId())
            .append("replyUserName", getReplyUserName())
            .append("status", getStatus())
            .append("likes", getLikes())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
} 