package com.ruoyi.web.controller.post.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.annotation.Excel.ColumnType;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 帖子收藏表 sys_post_favorite
 * 
 * @author thunderhub
 */
public class PostFavorite extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 收藏ID */
    @Excel(name = "收藏ID", cellType = ColumnType.NUMERIC)
    private Long favoriteId;

    /** 帖子ID */
    @Excel(name = "帖子ID")
    private Long postId;

    /** 用户ID */
    @Excel(name = "用户ID")
    private Long userId;

    /** 帖子标题 */
    @Excel(name = "帖子标题")
    private String postTitle;

    /** 帖子封面 */
    private String postCover;

    /** 收藏状态（0收藏 1取消） */
    @Excel(name = "收藏状态", readConverterExp = "0=收藏,1=取消")
    private String status;

    public Long getFavoriteId()
    {
        return favoriteId;
    }

    public void setFavoriteId(Long favoriteId)
    {
        this.favoriteId = favoriteId;
    }

    public Long getPostId()
    {
        return postId;
    }

    public void setPostId(Long postId)
    {
        this.postId = postId;
    }

    public Long getUserId()
    {
        return userId;
    }

    public void setUserId(Long userId)
    {
        this.userId = userId;
    }

    public String getPostTitle()
    {
        return postTitle;
    }

    public void setPostTitle(String postTitle)
    {
        this.postTitle = postTitle;
    }

    public String getPostCover()
    {
        return postCover;
    }

    public void setPostCover(String postCover)
    {
        this.postCover = postCover;
    }

    public String getStatus()
    {
        return status;
    }

    public void setStatus(String status)
    {
        this.status = status;
    }
    
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
            .append("favoriteId", getFavoriteId())
            .append("postId", getPostId())
            .append("userId", getUserId())
            .append("postTitle", getPostTitle())
            .append("postCover", getPostCover())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
} 