package com.ruoyi.web.controller.post.domain;

import java.math.BigDecimal;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 帖子推广计划对象 post_promotion_plan
 * 
 * @author thunderhub
 */
public class PostPromotionPlan extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 推广计划ID */
    private Long planId;

    /** 推广计划名称 */
    private String planName;

    /** 推广计划描述 */
    private String planDescription;

    /** 推广价格 */
    private BigDecimal price;

    /** 推广时长（天） */
    private Integer duration;

    /** 推广等级（数字越小等级越高） */
    private Integer level;

    /** 状态（0正常 1停用） */
    private String status;

    public void setPlanId(Long planId) 
    {
        this.planId = planId;
    }

    public Long getPlanId() 
    {
        return planId;
    }

    public void setPlanName(String planName) 
    {
        this.planName = planName;
    }

    public String getPlanName() 
    {
        return planName;
    }

    public void setPlanDescription(String planDescription) 
    {
        this.planDescription = planDescription;
    }

    public String getPlanDescription() 
    {
        return planDescription;
    }

    public void setPrice(BigDecimal price) 
    {
        this.price = price;
    }

    public BigDecimal getPrice() 
    {
        return price;
    }

    public void setDuration(Integer duration) 
    {
        this.duration = duration;
    }

    public Integer getDuration() 
    {
        return duration;
    }

    public void setLevel(Integer level) 
    {
        this.level = level;
    }

    public Integer getLevel() 
    {
        return level;
    }

    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return "PostPromotionPlan{" +
                "planId=" + planId +
                ", planName='" + planName + '\'' +
                ", planDescription='" + planDescription + '\'' +
                ", price=" + price +
                ", duration=" + duration +
                ", level=" + level +
                ", status='" + status + '\'' +
                '}';
    }
} 