package com.ruoyi.web.controller.post.mapper;

import java.util.List;
import com.ruoyi.web.controller.post.domain.PostPayment;
import org.apache.ibatis.annotations.Param;

/**
 * 帖子支付记录Mapper接口
 * 
 * @author thunderhub
 */
public interface PostPaymentMapper 
{
    /**
     * 查询帖子支付记录
     * 
     * @param paymentId 帖子支付记录ID
     * @return 帖子支付记录
     */
    public PostPayment selectPostPaymentById(Long paymentId);

    /**
     * 查询帖子支付记录列表
     * 
     * @param postPayment 帖子支付记录
     * @return 帖子支付记录集合
     */
    public List<PostPayment> selectPostPaymentList(PostPayment postPayment);

    /**
     * 根据帖子ID查询最新的支付记录
     * 
     * @param postId 帖子ID
     * @return 支付记录
     */
    public PostPayment selectLatestPaymentByPostId(Long postId);

    /**
     * 查询过期的推广支付记录
     * 
     * @return 过期的支付记录列表
     */
    public List<PostPayment> selectExpiredPromotionPayments();

    /**
     * 新增帖子支付记录
     * 
     * @param postPayment 帖子支付记录
     * @return 结果
     */
    public int insertPostPayment(PostPayment postPayment);

    /**
     * 修改帖子支付记录
     * 
     * @param postPayment 帖子支付记录
     * @return 结果
     */
    public int updatePostPayment(PostPayment postPayment);

    /**
     * 删除帖子支付记录
     * 
     * @param paymentId 帖子支付记录ID
     * @return 结果
     */
    public int deletePostPaymentById(Long paymentId);

    /**
     * 批量删除帖子支付记录
     * 
     * @param paymentIds 需要删除的数据ID
     * @return 结果
     */
    public int deletePostPaymentByIds(Long[] paymentIds);
} 