package com.ruoyi.web.controller.post.service;

import java.util.List;

import com.ruoyi.web.controller.post.domain.PostTag;

/**
 * 帖子标签 服务层
 * 
 * @author thunderhub
 */
public interface IPostTagService 
{
    /**
     * 查询帖子标签信息
     * 
     * @param tagId 帖子标签ID
     * @return 帖子标签信息
     */
    public PostTag selectPostTagById(Long tagId);

    /**
     * 查询帖子标签列表
     * 
     * @param postTag 帖子标签信息
     * @return 帖子标签集合
     */
    public List<PostTag> selectPostTagList(PostTag postTag);

    /**
     * 根据帖子ID查询标签
     * 
     * @param postId 帖子ID
     * @return 帖子标签集合
     */
    public List<PostTag> selectPostTagsByPostId(Long postId);

    /**
     * 新增帖子标签
     * 
     * @param postTag 帖子标签信息
     * @return 结果
     */
    public int insertPostTag(PostTag postTag);

    /**
     * 修改帖子标签
     * 
     * @param postTag 帖子标签信息
     * @return 结果
     */
    public int updatePostTag(PostTag postTag);

    /**
     * 删除帖子标签信息
     * 
     * @param tagId 帖子标签ID
     * @return 结果
     */
    public int deletePostTagById(Long tagId);

    /**
     * 批量删除帖子标签信息
     * 
     * @param tagIds 需要删除的帖子标签ID
     * @return 结果
     */
    public int deletePostTagByIds(Long[] tagIds);

    /**
     * 批量插入帖子标签关联
     * 
     * @param postId 帖子ID
     * @param tagIds 标签ID数组
     * @return 结果
     */
    public int batchInsertPostTagRelation(Long postId, Long[] tagIds);

    /**
     * 删除帖子标签关联
     * 
     * @param postId 帖子ID
     * @return 结果
     */
    public int deletePostTagRelation(Long postId);

    /**
     * 更新标签帖子数量
     * 
     * @param tagId 标签ID
     * @param count 增加/减少的数量
     * @return 结果
     */
    public int updatePostTagCount(Long tagId, int count);

    /**
     * 检查标签名称是否唯一
     * 
     * @param postTag 帖子标签信息
     * @return 结果
     */
    public boolean checkTagNameUnique(PostTag postTag);
} 