package com.ruoyi.web.controller.post.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ruoyi.web.controller.post.domain.PostComment;
import com.ruoyi.web.controller.post.mapper.PostCommentMapper;
import com.ruoyi.web.controller.post.service.IPostCommentService;

/**
 * 帖子评论 服务层实现
 * 
 * @author thunderhub
 */
@Service
public class PostCommentServiceImpl implements IPostCommentService
{
    @Autowired
    private PostCommentMapper postCommentMapper;

    /**
     * 查询帖子评论信息
     * 
     * @param commentId 帖子评论ID
     * @return 帖子评论信息
     */
    @Override
    public PostComment selectPostCommentById(Long commentId)
    {
        return postCommentMapper.selectPostCommentById(commentId);
    }

    /**
     * 查询帖子评论列表
     * 
     * @param postComment 帖子评论信息
     * @return 帖子评论集合
     */
    @Override
    public List<PostComment> selectPostCommentList(PostComment postComment)
    {
        return postCommentMapper.selectPostCommentList(postComment);
    }

    /**
     * 根据帖子ID查询评论
     * 
     * @param postId 帖子ID
     * @param limit 查询数量，0表示查询全部
     * @return 帖子评论集合
     */
    @Override
    public List<PostComment> selectCommentsByPostId(Long postId, int limit)
    {
        return postCommentMapper.selectCommentsByPostId(postId, limit);
    }

    /**
     * 根据父评论ID查询回复
     * 
     * @param parentId 父评论ID
     * @return 帖子评论集合
     */
    @Override
    public List<PostComment> selectCommentsByParentId(Long parentId)
    {
        return postCommentMapper.selectCommentsByParentId(parentId);
    }

    /**
     * 新增帖子评论
     * 
     * @param postComment 帖子评论信息
     * @return 结果
     */
    @Override
    public int insertPostComment(PostComment postComment)
    {
        return postCommentMapper.insertPostComment(postComment);
    }

    /**
     * 修改帖子评论
     * 
     * @param postComment 帖子评论信息
     * @return 结果
     */
    @Override
    public int updatePostComment(PostComment postComment)
    {
        return postCommentMapper.updatePostComment(postComment);
    }

    /**
     * 删除帖子评论信息
     * 
     * @param commentId 帖子评论ID
     * @return 结果
     */
    @Override
    public int deletePostCommentById(Long commentId)
    {
        return postCommentMapper.deletePostCommentById(commentId);
    }

    /**
     * 批量删除帖子评论信息
     * 
     * @param commentIds 需要删除的帖子评论ID
     * @return 结果
     */
    @Override
    public int deletePostCommentByIds(Long[] commentIds)
    {
        return postCommentMapper.deletePostCommentByIds(commentIds);
    }

    /**
     * 根据帖子ID删除评论
     * 
     * @param postId 帖子ID
     * @return 结果
     */
    @Override
    public int deletePostCommentByPostId(Long postId)
    {
        return postCommentMapper.deletePostCommentByPostId(postId);
    }

    /**
     * 更新评论点赞数
     * 
     * @param commentId 评论ID
     * @param count 增加/减少的数量
     * @return 结果
     */
    @Override
    public int updateCommentLikes(Long commentId, int count)
    {
        PostComment comment = new PostComment();
        comment.setCommentId(commentId);
        comment.setLikes((long) count);
        return postCommentMapper.updateCommentLikes(comment);
    }
}