package com.ruoyi.web.controller.post.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ruoyi.web.controller.post.domain.PostFavorite;
import com.ruoyi.web.controller.post.mapper.PostFavoriteMapper;
import com.ruoyi.web.controller.post.service.IPostFavoriteService;

/**
 * 帖子收藏 服务层实现
 * 
 * @author thunderhub
 */
@Service
public class PostFavoriteServiceImpl implements IPostFavoriteService
{
    @Autowired
    private PostFavoriteMapper postFavoriteMapper;

    /**
     * 查询帖子收藏信息
     * 
     * @param favoriteId 帖子收藏ID
     * @return 帖子收藏信息
     */
    @Override
    public PostFavorite selectPostFavoriteById(Long favoriteId)
    {
        return postFavoriteMapper.selectPostFavoriteById(favoriteId);
    }

    /**
     * 查询帖子收藏列表
     * 
     * @param postFavorite 帖子收藏信息
     * @return 帖子收藏集合
     */
    @Override
    public List<PostFavorite> selectPostFavoriteList(PostFavorite postFavorite)
    {
        return postFavoriteMapper.selectPostFavoriteList(postFavorite);
    }

    /**
     * 查询用户是否收藏帖子
     * 
     * @param postId 帖子ID
     * @param userId 用户ID
     * @return 收藏信息
     */
    @Override
    public PostFavorite selectPostFavoriteByPostIdAndUserId(Long postId, Long userId)
    {
        return postFavoriteMapper.selectPostFavoriteByPostIdAndUserId(postId, userId);
    }

    /**
     * 新增帖子收藏
     * 
     * @param postFavorite 帖子收藏信息
     * @return 结果
     */
    @Override
    public int insertPostFavorite(PostFavorite postFavorite)
    {
        return postFavoriteMapper.insertPostFavorite(postFavorite);
    }

    /**
     * 修改帖子收藏
     * 
     * @param postFavorite 帖子收藏信息
     * @return 结果
     */
    @Override
    public int updatePostFavorite(PostFavorite postFavorite)
    {
        return postFavoriteMapper.updatePostFavorite(postFavorite);
    }

    /**
     * 删除帖子收藏信息
     * 
     * @param favoriteId 帖子收藏ID
     * @return 结果
     */
    @Override
    public int deletePostFavoriteById(Long favoriteId)
    {
        return postFavoriteMapper.deletePostFavoriteById(favoriteId);
    }

    /**
     * 批量删除帖子收藏信息
     * 
     * @param favoriteIds 需要删除的帖子收藏ID
     * @return 结果
     */
    @Override
    public int deletePostFavoriteByIds(Long[] favoriteIds)
    {
        return postFavoriteMapper.deletePostFavoriteByIds(favoriteIds);
    }

    /**
     * 取消收藏帖子
     * 
     * @param postId 帖子ID
     * @param userId 用户ID
     * @return 结果
     */
    @Override
    public int cancelPostFavorite(Long postId, Long userId)
    {
        return postFavoriteMapper.cancelPostFavorite(postId, userId);
    }

    /**
     * 根据帖子ID删除收藏
     * 
     * @param postId 帖子ID
     * @return 结果
     */
    @Override
    public int deletePostFavoriteByPostId(Long postId)
    {
        return postFavoriteMapper.deletePostFavoriteByPostId(postId);
    }

    /**
     * 根据用户ID查询收藏列表
     * 
     * @param userId 用户ID
     * @return 收藏列表
     */
    @Override
    public List<PostFavorite> selectPostFavoritesByUserId(Long userId)
    {
        PostFavorite postFavorite = new PostFavorite();
        postFavorite.setUserId(userId);
        return postFavoriteMapper.selectPostFavoriteList(postFavorite);
    }
} 