package com.ruoyi.web.controller.post.task;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import com.ruoyi.web.controller.post.service.IPostService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 推广时效性检查定时任务
 * 
 * @author thunderhub
 */
@Component
public class PromotionExpiryTask
{
    private static final Logger logger = LoggerFactory.getLogger(PromotionExpiryTask.class);

    @Autowired
    private IPostService postService;

    /**
     * 检查推广时效性
     * 每小时执行一次
     */
    @Scheduled(cron = "0 0 * * * ?")
    public void checkPromotionExpiry()
    {
        logger.info("开始检查推广时效性...");
        
        try {
            int processedCount = postService.checkAndHandleExpiredPromotions();
            logger.info("推广时效性检查完成，处理了 {} 个过期推广", processedCount);
        } catch (Exception e) {
            logger.error("推广时效性检查失败", e);
        }
    }

    /**
     * 手动触发推广时效性检查
     * 用于测试或手动执行
     */
    public void manualCheckPromotionExpiry()
    {
        logger.info("手动触发推广时效性检查...");
        checkPromotionExpiry();
    }
} 