package com.ruoyi;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.web.server.ConfigurableWebServerFactory;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

/**
 * 启动程序
 * 
 * @author ruoyi
 */

@ComponentScan(basePackages = {
        "com.ruoyi",
        "bounty"  // 新增您的包路径
})
// 关键添加：扩大MyBatis接口扫描范围
@MapperScan(basePackages = {
        "com.ruoyi.**.mapper",
        "bounty.mapper",
        "com.ruoyi.web.dao.BT",
        "com.ruoyi.web.dao.sys"
})

@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class })
public class RuoYiApplication {
    public static void main(String[] args) {

        // System.setProperty("spring.devtools.restart.enabled", "false");
        SpringApplication.run(RuoYiApplication.class, args);
        // ANSI escape code for blue text
        String blue = "\u001B[34m";
        // ANSI escape code to reset text color
        String reset = "\u001B[0m";

        System.out.println(blue + " ----我爱雨滔身体好好 喵喵 喵 喵" + reset);
    }

    @Bean
    public WebServerFactoryCustomizer<ConfigurableWebServerFactory> webServerFactoryCustomizer() {
        return factory -> {
            ErrorPage error404Page = new ErrorPage("/index.html");
            factory.addErrorPages(error404Page);
        };
    }
}
