package com.ruoyi.web.dao.sys;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.web.domain.sys.UserEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Set;

/**
 * @author Jrx
 */

@Mapper
public interface UserDao extends BaseMapper<UserEntity> {


    /**
     * 查询用户的所有权限
     *
     * @param userId 用户ID
     */
    List<String> queryAllPerms(Integer userId);

    @Select("select * from sys_user where id in (#{userIds})")
    Set<UserEntity> findByIds(Set<Long> userIds);

    Set<String> listUserPermissions(Integer userId);

    @Select("SELECT * FROM sys_user u LEFT JOIN sys_user_credential uc on uc.id = u.user_id WHERE uc.passkey=#{passkey}")
    UserEntity findUserByPasskey(String passkey);

    @Select("SELECT * FROM sys_user WHERE user_id=#{id}")
    UserEntity findUserById(Integer id);


}
