package com.ruoyi.web.domain.sys;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 用户
 * @author Jrx
 */
@Data
@TableName("sys_user")
public class UserEntity implements Serializable {

    @TableId(value = "user_id", type = IdType.AUTO)
    private Long user_id;
    private String user_name;
    private String nick_name;
    private String user_type;
    private String email;
    private String phonenumber;

    // 数据库字段为sex，实体类使用gender更符合语义
    @TableField("sex")
    private String gender;

    private String avatar;
    private String password;

    // 状态字段映射
    @TableField("status")
    private Integer status;

    private String login_ip;

    // 日期类型统一使用LocalDateTime
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime login_date;

    private String create_by;

    // 修正字段名与数据库一致
    @TableField("create_time")
    private LocalDateTime create_time;

    private String update_by;

    // 修正字段名与数据库一致
    @TableField("update_time")
    private LocalDateTime update_time;

    private String remark;
    private String full_name;

    // 使用Integer而非自定义枚举，与数据库字段类型一致
    private Integer state;

    private LocalDateTime added;
    private LocalDateTime last_login;
    private LocalDateTime last_access;
    private LocalDateTime last_home;
    private LocalDateTime last_offer;
    private LocalDateTime forum_access;
    private LocalDateTime last_staffmsg;
    private LocalDateTime last_pm;
    private LocalDateTime last_comment;
    private LocalDateTime last_post;
    private LocalDateTime last_active;

    private Integer privacy;
    private String reg_ip;
    private Integer level;
    private Long seedtime;
    private Long leechtime;

    @Schema(description = "真实上传量")
    private Long real_uploaded;

    @Schema(description = "真实下载量")
    private Long real_downloaded;

    private String modcomment;
    private Long warning_by;
    private Integer warning_times;
    private Boolean warning;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime warning_until;

    private Long download;
    private Long upload;
    private Integer invited_by;
    private Long bonus;
    private Long exp;
    private String check_code;
    private Integer reg_type;

    // 状态辅助方法
    public boolean isUserLocked() {
        return this.state != null && this.state == 1;
    }

    public boolean isUserOK() {
        return this.state != null && this.state == 0;
    }
}
