package com.ruoyi.web.Server.validator;

import com.ruoyi.web.controller.common.exception.TrackerNoRetryException;
import com.ruoyi.web.dao.BT.AnnounceRequest;
import org.springframework.stereotype.Component;


@Component
public class PasskeyValidator implements TrackerValidator {


    @Override
    public void validate(AnnounceRequest request) {

        //todo 验证Passkey, 增加签名算法
        int length = request.getPasskey().length();
        if (length > 64 || length < 16) {
            throw new TrackerNoRetryException("Invalid passkey. QAQ");
        }
    }

    @Override
    public int getOrder() {
        return 2;
    }
}
