package com.ruoyi.web.Server.validator;

import com.ruoyi.web.controller.common.exception.TrackerException;
import com.ruoyi.web.dao.sys.UserDao;
import com.ruoyi.web.domain.sys.UserEntity;
import com.ruoyi.web.dao.BT.AnnounceRequest;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;


@RequiredArgsConstructor
@Component
public class UserValidator implements TrackerValidator {


    final UserDao userDao;

    @Override
    public void validate(AnnounceRequest request) {

        UserEntity user = userDao.findUserByPasskey(request.getPasskey());

        if (user == null) {
            throw new TrackerException("passkey invalid, pls redownload the torrent file.");
        }


        if (!user.isUserOK()) {
            throw new TrackerException("user invalid");
        }


        request.setUser(user);

    }

    @Override
    public int getOrder() {
        return 100;
    }


}
