package com.ruoyi.web.Server.validator;


import com.ruoyi.web.dao.BT.AnnounceRequest;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
public class ValidationManager {

    List<TrackerValidator> validators;

    @Autowired
    public ValidationManager(List<TrackerValidator> validatorList) {
        this.validators = validatorList.stream()
                .sorted(Comparator.comparing(TrackerValidator::getOrder))
                .collect(Collectors.toList());
    }


    public void validate(AnnounceRequest object) {
        for (TrackerValidator validator : validators) {
            validator.validate(object);
        }
    }

}
