package com.ruoyi.web.Tool.BT;

import com.dampcake.bencode.BencodeOutputStream;
import com.ruoyi.web.controller.common.exception.TrackerException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 编解码
 */
public class BencodeUtil {

    public static final String exceptionMsg = "Oops! Your request is like an alien language to us, we " +
            "can't encode it!";

    public interface Errors {
        String CLIENT_ERROR = BencodeUtil.error("Oops! Your request is like an alien language to " +
                "us, we can't decode it!");
        String INTERNAL_ERROR_60 = BencodeUtil.error("Give us a moment, try again later!", 60);
        String INTERNAL_ERROR_120 = BencodeUtil.error("Hold your horses! then try again later!",
                120);


    }

    public static String error(String reason) {
        return encode(Map.of("failure reason", reason));
    }

    public static String errorNoRetry(String reason) {
        return encode(Map.of("failure reason", reason,
                "retry in", "never"
        ));
    }

    public static String warning(String reason) {
        return encode(Map.of("warning message", reason));
    }

    public static String error() {
        return Errors.CLIENT_ERROR;
    }


    public static String error(String reason, Integer retry) {
        return encode(Map.of("failure reason", reason, "retry in", retry));
    }

    public static <K, V> String encode(Map<K, V> data) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
            try (BencodeOutputStream bencoder = new BencodeOutputStream(out)) {
                bencoder.writeDictionary(data);
                return out.toString();
            }
        } catch (IOException e) {
            throw new TrackerException(exceptionMsg, e);
        }
    }

    public static String encode(Integer data) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
            try (BencodeOutputStream bencoder = new BencodeOutputStream(out)) {
                bencoder.write(data);
                return out.toString();
            }
        } catch (IOException e) {
            throw new TrackerException(exceptionMsg, e);
        }
    }

    public static String encode(Number data) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
            try (BencodeOutputStream bencoder = new BencodeOutputStream(out)) {
                bencoder.writeNumber(data);
                return out.toString();
            }
        } catch (IOException e) {
            throw new TrackerException(exceptionMsg, e);
        }
    }

    public static String encode(byte[] data) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
            try (BencodeOutputStream bencoder = new BencodeOutputStream(out)) {
                bencoder.write(data);
                return out.toString();
            }
        } catch (IOException e) {
            throw new TrackerException(exceptionMsg, e);
        }
    }

    public static String encode(byte[] data, int offset, int length) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
            try (BencodeOutputStream bencoder = new BencodeOutputStream(out)) {
                bencoder.write(data, offset, length);
                return out.toString();
            }
        } catch (IOException e) {
            throw new TrackerException(exceptionMsg, e);
        }
    }

    public static String encode(String data) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
            try (BencodeOutputStream bencoder = new BencodeOutputStream(out)) {
                bencoder.writeString(data);
                return out.toString();
            }
        } catch (IOException e) {
            throw new TrackerException(exceptionMsg, e);
        }
    }

    public static <E> String encode(List<E> data) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
            try (BencodeOutputStream bencoder = new BencodeOutputStream(out)) {
                bencoder.writeList(data);
                return out.toString();
            }
        } catch (IOException e) {
            throw new TrackerException(exceptionMsg, e);
        }
    }
}
