package com.ruoyi.web.controller.common.exception;

import com.ruoyi.web.controller.common.CommonResultStatus;
import com.ruoyi.web.controller.common.ResultStatus;

/**
 * @author Jrx
 */
public class RocketPTException extends RuntimeException {
    private final ResultStatus status;

    public RocketPTException(ResultStatus status) {
        super(status.getMessage());
        this.status = status;
    }

    public RocketPTException(ResultStatus status, String message) {
        super(message);
        this.status = status;
    }

    public RocketPTException(com.ruoyi.web.controller.common.CommonResultStatus paramError, String message) {
        super(message);
        this.status = CommonResultStatus.FAIL;
    }
    public RocketPTException(String message) {
        super(message);
        this.status = CommonResultStatus.FAIL;
    }

    public ResultStatus getStatus() {
        return status;
    }


}
