package com.ruoyi.web.controller.planet;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.web.controller.common.base.PageUtil;
import com.ruoyi.web.controller.common.base.Result;
import com.ruoyi.web.domain.planet.Planet;
import com.ruoyi.web.domain.planet.UserPlanet;
import com.ruoyi.web.Server.planet.IPlanetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @program: ThunderHubServer
 * @description: 后端API控制器，处理星球相关请求
 * @author: Yumaoo
 * @create: 2025-06-08 17:23
 **/
@RestController
@RequestMapping("/planets")
public class Controller {
    @Autowired
    private IPlanetService planetService;

    /**
     * 分页查询星球列表
     */
    @GetMapping("/list")
    public Result getPlanetList(@RequestParam(defaultValue = "1") Long pageNum,
                                    @RequestParam(defaultValue = "10") Long pageSize) {
        List<Planet> list = planetService.getPlanetList(pageNum, pageSize);
        System.out.println("########################");
        System.out.println(list);
        return Result.ok(list, PageUtil.getPage(list));
    }

    /**
     * 获取星球详情
     */
    @GetMapping("/info/{id}")
    public AjaxResult getPlanetInfo(@PathVariable String id) {
        // 前端支持字符串ID，后端统一转为Long类型
        return AjaxResult.success(planetService.getPlanetById(Long.valueOf(id)));
    }

    /**
     * 上传星球文件
     */
    @PostMapping("/upload")
    public AjaxResult uploadPlanetFile(@RequestParam("file") MultipartFile file) {
        Planet planet = planetService.uploadPlanetFile(file);
        return AjaxResult.success(planet);
    }

    /**
     * 获取用户星球信息
     */
    @GetMapping("/user")
    public AjaxResult getUserPlanet(@RequestParam Long userId) {
        return AjaxResult.success(planetService.getUserPlanetByUserId(userId));
    }

    /**
     * 随机获得用户和绑定的星球
     */
    @GetMapping("/random")
    public Result getRandomUserPlanets() {
        List<UserPlanet> list = planetService.getUserPlanetList();
        System.out.println("########################");
        System.out.println(list);
        List<UserPlanet> result;
        if (list.size() <= 3) {
            result = new ArrayList<>(list);
        } else {
            List<UserPlanet> shuffledList = new ArrayList<>(list);
            Collections.shuffle(shuffledList);
            result = shuffledList.subList(0, 3);
        }
        return Result.ok(result, PageUtil.getPage(list));
    }

    /**
     * 更新星球信息
     */
    @PostMapping("/update")
    public AjaxResult updatePlanet(@RequestBody Planet planet) {
        planetService.updatePlanet(planet);
        return AjaxResult.success();
    }
    @PostMapping("/updateUserPlanet")
    public AjaxResult updateUserPlanet(@RequestBody UserPlanet userPlanet) {
        userPlanet.setUpdateTime(new java.util.Date());
        System.out.println("##########");
        System.out.println(userPlanet);
        planetService.updateUserPlanet(userPlanet);
        return AjaxResult.success();
    }

    /**
     * 删除星球
     */
    @PostMapping("/delete")
    public AjaxResult deletePlanet(@RequestBody List<Long> ids) {
        // 强制类型转换以适配服务层接口
        planetService.deletePlanets((java.util.List<Long>) ids);
        return AjaxResult.success();
    }
}