package com.ruoyi.web.controller.post.domain;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.annotation.Excel.ColumnType;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 帖子表 sys_post
 * 
 * @author thunderhub
 */
public class Post extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 帖子ID */
    @Excel(name = "帖子ID", cellType = ColumnType.NUMERIC)
    private Long postId;

    /** 帖子标题 */
    @Excel(name = "帖子标题")
    private String title;

    /** 帖子内容（富文本） */
    private String content;

    /** 帖子摘要 */
    @Excel(name = "帖子摘要")
    private String summary;

    /** 封面图片URL */
    @Excel(name = "封面图片")
    private String coverImage;

    /** 作者ID */
    @Excel(name = "作者ID")
    private Long authorId;

    /** 作者名称 */
    @Excel(name = "作者名称")
    private String author;

    /** 浏览量 */
    @Excel(name = "浏览量")
    private Long views;

    /** 评论数 */
    @Excel(name = "评论数")
    private Long comments;

    /** 收藏数 */
    @Excel(name = "收藏数")
    private Long favorites;

    /** 点赞数 */
    @Excel(name = "点赞数")
    private Long likes;

    /** 状态（0待审核 1正常 2拒绝 3下架） */
    @Excel(name = "状态", readConverterExp = "0=待审核,1=正常,2=拒绝,3=下架")
    private String status;

    /** 发布时间 */
    @Excel(name = "发布时间")
    private String publishTime;
    
    /** 标签列表，用逗号分隔 */
    private String tags;

    /** 推广计划ID */
    @Excel(name = "推广计划ID")
    private Long promotionPlanId;

    public Long getPostId()
    {
        return postId;
    }

    public void setPostId(Long postId)
    {
        this.postId = postId;
    }

    @NotBlank(message = "帖子标题不能为空")
    @Size(min = 0, max = 100, message = "帖子标题长度不能超过100个字符")
    public String getTitle()
    {
        return title;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public String getContent()
    {
        return content;
    }

    public void setContent(String content)
    {
        this.content = content;
    }

    @Size(min = 0, max = 500, message = "帖子摘要长度不能超过500个字符")
    public String getSummary()
    {
        return summary;
    }

    public void setSummary(String summary)
    {
        this.summary = summary;
    }

    public String getCoverImage()
    {
        return coverImage;
    }

    public void setCoverImage(String coverImage)
    {
        this.coverImage = coverImage;
    }

    public Long getAuthorId()
    {
        return authorId;
    }

    public void setAuthorId(Long authorId)
    {
        this.authorId = authorId;
    }

    public String getAuthor()
    {
        return author;
    }

    public void setAuthor(String author)
    {
        this.author = author;
    }

    public Long getViews()
    {
        return views;
    }

    public void setViews(Long views)
    {
        this.views = views;
    }

    public Long getComments()
    {
        return comments;
    }

    public void setComments(Long comments)
    {
        this.comments = comments;
    }

    public Long getFavorites()
    {
        return favorites;
    }

    public void setFavorites(Long favorites)
    {
        this.favorites = favorites;
    }

    public Long getLikes()
    {
        return likes;
    }

    public void setLikes(Long likes)
    {
        this.likes = likes;
    }

    public String getStatus()
    {
        return status;
    }

    public void setStatus(String status)
    {
        this.status = status;
    }

    public String getPublishTime()
    {
        return publishTime;
    }

    public void setPublishTime(String publishTime)
    {
        this.publishTime = publishTime;
    }
    
    public String getTags()
    {
        return tags;
    }

    public void setTags(String tags)
    {
        this.tags = tags;
    }

    public Long getPromotionPlanId()
    {
        return promotionPlanId;
    }

    public void setPromotionPlanId(Long promotionPlanId)
    {
        this.promotionPlanId = promotionPlanId;
    }
    
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
            .append("postId", getPostId())
            .append("title", getTitle())
            .append("content", getContent())
            .append("summary", getSummary())
            .append("coverImage", getCoverImage())
            .append("authorId", getAuthorId())
            .append("author", getAuthor())
            .append("views", getViews())
            .append("comments", getComments())
            .append("favorites", getFavorites())
            .append("likes", getLikes())
            .append("status", getStatus())
            .append("publishTime", getPublishTime())
            .append("tags", getTags())
            .append("promotionPlanId", getPromotionPlanId())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
} 