package com.ruoyi.web.controller.post.mapper;

import java.util.List;

import com.ruoyi.web.controller.post.domain.PostTag;
import com.ruoyi.web.controller.post.domain.PostTagRelation;
import org.apache.ibatis.annotations.Mapper;

/**
 * 帖子标签Mapper接口
 * 
 * @author thunderhub
 */
@Mapper
public interface PostContentTagMapper 
{
    /**
     * 查询帖子标签信息
     * 
     * @param tagId 帖子标签ID
     * @return 帖子标签信息
     */
    public PostTag selectPostTagById(Long tagId);

    /**
     * 查询帖子标签列表
     * 
     * @param postTag 帖子标签信息
     * @return 帖子标签集合
     */
    public List<PostTag> selectPostTagList(PostTag postTag);

    /**
     * 根据帖子ID查询标签
     * 
     * @param postId 帖子ID
     * @return 帖子标签集合
     */
    public List<PostTag> selectPostTagsByPostId(Long postId);

    /**
     * 新增帖子标签
     * 
     * @param postTag 帖子标签信息
     * @return 结果
     */
    public int insertPostTag(PostTag postTag);

    /**
     * 修改帖子标签
     * 
     * @param postTag 帖子标签信息
     * @return 结果
     */
    public int updatePostTag(PostTag postTag);

    /**
     * 删除帖子标签
     * 
     * @param tagId 帖子标签ID
     * @return 结果
     */
    public int deletePostTagById(Long tagId);

    /**
     * 批量删除帖子标签
     * 
     * @param tagIds 需要删除的帖子标签ID
     * @return 结果
     */
    public int deletePostTagByIds(Long[] tagIds);

    /**
     * 插入帖子标签关联
     * 
     * @param relation 关联信息
     * @return 结果
     */
    public int insertPostTagRelation(PostTagRelation relation);

    /**
     * 批量插入帖子标签关联
     * 
     * @param list 关联列表
     * @return 结果
     */
    public int batchInsertPostTagRelation(List<PostTagRelation> list);

    /**
     * 删除帖子标签关联
     * 
     * @param postId 帖子ID
     * @return 结果
     */
    public int deletePostTagRelation(Long postId);

    /**
     * 更新标签帖子数量
     * 
     * @param postTag 帖子标签信息
     * @return 结果
     */
    public int updatePostTagCount(PostTag postTag);

    /**
     * 校验标签名称是否唯一
     * 
     * @param tagName 标签名称
     * @return 结果
     */
    public PostTag checkTagNameUnique(String tagName);
} 