package com.ruoyi.web.controller.post.mapper;

import java.util.List;
import com.ruoyi.web.controller.post.domain.PostPromotionPlan;

/**
 * 帖子推广计划Mapper接口
 * 
 * @author thunderhub
 */
public interface PostPromotionPlanMapper 
{
    /**
     * 查询帖子推广计划
     * 
     * @param planId 帖子推广计划ID
     * @return 帖子推广计划
     */
    public PostPromotionPlan selectPostPromotionPlanById(Long planId);

    /**
     * 查询帖子推广计划列表
     * 
     * @param postPromotionPlan 帖子推广计划
     * @return 帖子推广计划集合
     */
    public List<PostPromotionPlan> selectPostPromotionPlanList(PostPromotionPlan postPromotionPlan);

    /**
     * 新增帖子推广计划
     * 
     * @param postPromotionPlan 帖子推广计划
     * @return 结果
     */
    public int insertPostPromotionPlan(PostPromotionPlan postPromotionPlan);

    /**
     * 修改帖子推广计划
     * 
     * @param postPromotionPlan 帖子推广计划
     * @return 结果
     */
    public int updatePostPromotionPlan(PostPromotionPlan postPromotionPlan);

    /**
     * 删除帖子推广计划
     * 
     * @param planId 帖子推广计划ID
     * @return 结果
     */
    public int deletePostPromotionPlanById(Long planId);

    /**
     * 批量删除帖子推广计划
     * 
     * @param planIds 需要删除的数据ID
     * @return 结果
     */
    public int deletePostPromotionPlanByIds(Long[] planIds);
} 