package com.ruoyi.web.controller.post.mapper;

import java.util.List;
import com.ruoyi.web.controller.post.domain.PostReport;

/**
 * 帖子举报Mapper接口
 * 
 * @author thunderhub
 */
public interface PostReportMapper 
{
    /**
     * 查询帖子举报
     * 
     * @param reportId 帖子举报ID
     * @return 帖子举报
     */
    public PostReport selectPostReportById(Long reportId);

    /**
     * 查询帖子举报列表
     * 
     * @param postReport 帖子举报
     * @return 帖子举报集合
     */
    public List<PostReport> selectPostReportList(PostReport postReport);

    /**
     * 新增帖子举报
     * 
     * @param postReport 帖子举报
     * @return 结果
     */
    public int insertPostReport(PostReport postReport);

    /**
     * 修改帖子举报
     * 
     * @param postReport 帖子举报
     * @return 结果
     */
    public int updatePostReport(PostReport postReport);

    /**
     * 删除帖子举报
     * 
     * @param reportId 帖子举报ID
     * @return 结果
     */
    public int deletePostReportById(Long reportId);

    /**
     * 批量删除帖子举报
     * 
     * @param reportIds 需要删除的数据ID
     * @return 结果
     */
    public int deletePostReportByIds(Long[] reportIds);
} 