package com.ruoyi.web.controller.post.service;

import java.util.List;

import com.ruoyi.web.controller.post.domain.Post;

/**
 * 帖子 服务层
 * 
 * @author thunderhub
 */
public interface IPostService 
{
    /**
     * 查询帖子信息
     * 
     * @param postId 帖子ID
     * @return 帖子信息
     */
    public Post selectPostById(Long postId);

    /**
     * 查询帖子列表
     * 
     * @param post 帖子信息
     * @return 帖子集合
     */
    public List<Post> selectPostList(Post post);

    /**
     * 查询作者的其他帖子
     * 
     * @param authorId 作者ID
     * @param postId 当前帖子ID（排除）
     * @param limit 查询数量
     * @return 帖子集合
     */
    public List<Post> selectAuthorOtherPosts(Long authorId, Long postId, int limit);

    /**
     * 查询相似标签的帖子
     * 
     * @param tags 标签列表
     * @param postId 当前帖子ID（排除）
     * @param limit 查询数量
     * @return 帖子集合
     */
    public List<Post> selectSimilarTagsPosts(String tags, Long postId, int limit);

    /**
     * 获取帖子推荐列表（包含作者其他帖子和相似标签帖子）
     * 
     * @param authorId 作者ID
     * @param tags 标签列表
     * @param postId 当前帖子ID（排除）
     * @param maxCount 最大推荐数量
     * @return 推荐帖子集合
     */
    public List<Post> getRecommendedPosts(Long authorId, String tags, Long postId, int maxCount);

    /**
     * 新增帖子
     * 
     * @param post 帖子信息
     * @return 结果
     */
    public int insertPost(Post post);

    /**
     * 修改帖子
     * 
     * @param post 帖子信息
     * @return 结果
     */
    public int updatePost(Post post);

    /**
     * 删除帖子信息
     * 
     * @param postId 帖子ID
     * @return 结果
     */
    public int deletePostById(Long postId);

    /**
     * 批量删除帖子信息
     * 
     * @param postIds 需要删除的帖子ID
     * @return 结果
     */
    public int deletePostByIds(Long[] postIds);

    /**
     * 更新帖子浏览量
     * 
     * @param postId 帖子ID
     * @return 结果
     */
    public int updatePostViews(Long postId);

    /**
     * 更新帖子评论数
     * 
     * @param postId 帖子ID
     * @param count 增加/减少的数量
     * @return 结果
     */
    public int updatePostComments(Long postId, int count);

    /**
     * 更新帖子收藏数
     * 
     * @param postId 帖子ID
     * @param count 增加/减少的数量
     * @return 结果
     */
    public int updatePostFavorites(Long postId, int count);

    /**
     * 更新帖子点赞数
     * 
     * @param postId 帖子ID
     * @param count 增加/减少的数量
     * @return 结果
     */
    public int updatePostLikes(Long postId, int count);

    /**
     * 检查并处理过期的推广帖子
     * 
     * @return 处理的帖子数量
     */
    public int checkAndHandleExpiredPromotions();

    /**
     * 取消帖子推广
     * 
     * @param postId 帖子ID
     * @return 结果
     */
    public int cancelPostPromotion(Long postId);
} 