package com.ruoyi.web.controller.system;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.model.RegisterBody;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.web.service.SysRegisterService;
import com.ruoyi.system.service.ISysConfigService;

/**
 * 注册验证
 * 
 * @author ruoyi
 */
@RestController
public class SysRegisterController extends BaseController
{
    @Autowired
    private SysRegisterService registerService;

    @Autowired
    private ISysConfigService configService;

    @PostMapping("/register")
    public AjaxResult register(@RequestBody RegisterBody user)
    {
        if (!("true".equals(configService.selectConfigByKey("sys.account.registerUser"))))
        {
            return error("当前系统没有开启注册功能！");
        }
        String msg = registerService.register(user);
        return StringUtils.isEmpty(msg) ? success() : error(msg);
            // 创建用户凭证实体
//        UserCredentialEntity userCredentialEntity = new UserCredentialEntity();
//        userCredentialEntity.setId(userEntity.getId());
//        userCredentialEntity.setUsername(param.getUsername());
//        userCredentialEntity.setRegIp(IPUtils.getIpAddr());
//        userCredentialEntity.setRegType(param.getType());
//        String checkCode = passkeyManager.generate(userEntity.getId());
//        userCredentialEntity.setCheckCode(checkCode);
//
//        // 生成随机盐和密码
//        String salt = RandomUtil.randomString(8);
//        String passkey = passkeyManager.generate(userEntity.getId());
//
//        userCredentialEntity.setSalt(salt);
//        userCredentialEntity.setPasskey(passkey);
//        String generatedPassword = userCredentialService.generate(param.getPassword(), salt);
//        userCredentialEntity.setPassword(generatedPassword);
//
//        // 保存用户凭证实体
//        userCredentialService.save(userCredentialEntity);
//        userRoleService.register(userEntity.getId());





    }
}
