package com.ruoyi.web.dao.BT;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.web.domain.BT.TagCatEntity;
import com.ruoyi.web.domain.BT.TagEntity;
import org.apache.ibatis.annotations.*;

import java.util.List;


@Mapper
public interface TagDao extends BaseMapper<TagEntity> {
    @Select("select * from bt_tag")
    List<TagEntity> all_tag();
    @Select("select * from bt_cat")
    List<TagCatEntity> all_cat();
    @Select("select * from bt_tag where id=#{id}")
    TagEntity findById(Long id);

    @Select("SELECT COUNT(*) FROM bt_tag WHERE name = #{name}")
    @ResultType(Integer.class)
    boolean existsByName(String name);

    @Select("SELECT COUNT(*) FROM bt_tag WHERE name = #{name} AND id != #{id}")
    @ResultType(Integer.class)
    boolean existsByNameAndNotId(String name, Long id);

    @Insert("INSERT INTO bt_tag (name, description, create_time, update_time) " +
            "VALUES (#{name}, #{description}, #{createTime}, #{updateTime})")
    @Options(useGeneratedKeys = true, keyProperty = "id")
    int insert(TagEntity tag);

    @Delete("DELETE FROM bt_tag WHERE id = #{id}")
    int delete(Long id);

    @Update("""
    UPDATE bt_tag 
    SET name = #{name}, 
        remark = #{remark}, 
        cat = #{cat}, 
        update_time = #{updateTime} 
    WHERE id = #{id}
""")
    int update(TagEntity tag);

}
