package com.ruoyi.web.dao.BT;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.web.domain.BT.TorrentPeerEntity;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Options;

/**
 * 种子Peer
 *
 */
@Mapper
public interface TorrentPeerDao extends BaseMapper<TorrentPeerEntity> {
    @Insert("INSERT INTO bt_torrent_peer (" +
            "torrent_id, user_id, peer_id, peer_id_hex, ip, port, " +
            "uploaded, downloaded, remaining, seeder, user_agent, passkey, create_time, last_announce" +
            ") " +
            "VALUES (" +
            "#{torrentId}, #{userId}, #{peerId}, #{peerIdHex}, #{ip}, #{port}, " +
            "#{uploaded}, #{downloaded}, #{remaining}, #{seeder}, #{userAgent}, #{passkey}, " +
            "#{createTime}, #{lastAnnounce}" +
            ") " +
            "ON DUPLICATE KEY UPDATE " +
            "ip = VALUES(ip), " +
            "port = VALUES(port), " +
            "uploaded = VALUES(uploaded), " +
            "downloaded = VALUES(downloaded), " +
            "remaining = VALUES(remaining), " +
            "seeder = VALUES(seeder), " +
            "user_agent = VALUES(user_agent), " +
            "passkey = VALUES(passkey), " +
            "last_announce = VALUES(last_announce)")
    @Options(useGeneratedKeys = true, keyProperty = "id", keyColumn = "id")
    int insertOrUpdate(TorrentPeerEntity entity);
}
