package com.ruoyi.web.domain.BT;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.time.LocalDateTime;

@Data
@TableName("bt_torrent")
public class TorrentEntity {

    @TableId
    private Integer id;

    private byte[] infoHash;
    private String name;
    private String filename;
    private String title;
    private String subheading;
    private String cover;
    private String description;

    // === 为所有数字统计字段添加默认值 ===

    /**
     * 类别
     */
    private Integer category = 0;  // 默认类别为0

    /**
     * 状态
     * @see Status
     */
    private Integer status = Status.CANDIDATE;  // 默认状态为候选中

    /**
     * 文件状态 0 未上传 1 已上传
     */
    private Integer fileStatus = 0;  // 默认文件未上传

    /**
     * 审核人 - 允许为null
     */
    private Integer reviewer;  // 未审核时为null

    private LocalDateTime createTime;
    private LocalDateTime updateTime;

    /**
     * 拥有者 - 必须设置，不需要默认值
     */
    private Integer owner;

    /**
     * 文件大小
     */
    private Long size = 0L;  // 默认0

    /**
     * 类型 single(1)/multi(2)
     */
    private Integer type = 1;  // 默认单文件

    /**
     * 文件数量
     */
    private Integer fileCount = 1;  // 默认1个文件

    /**
     * 评论数
     */
    private Integer comments = 0;  // 默认0评论

    /**
     * 浏览次数
     */
    private Integer views = 0;  // 默认0次浏览

    /**
     * 点击次数
     */
    private Integer hits = 0;  // 默认0点击

    /**
     * 可见性
     */
    private Integer visible = 1;  // 默认可见

    /**
     * 是否匿名
     */
    private Integer anonymous = 0;  // 默认不匿名

    /**
     * 下载数
     */
    private Integer leechers = 0;  // 关键: 默认0下载

    /**
     * 做种数
     */
    private Integer seeders = 0;  // 关键: 默认0做种

    /**
     * 做种完成次数
     */
    private Integer completions = 0;  // 默认0完成

    /**
     * 备注 - 允许为null
     */
    private String remark;

    /**
     * 种子状态
     */
    public interface Status {
        int CANDIDATE = 0;
        int PUBLISHED = 1;
        int AUDIT_NOT_PASSED = 2;
        int RETRIAL = 3;
        int REMOVED = 10;
    }

    @RequiredArgsConstructor
    public enum Type {
        single(1),
        multi(2);

        @Getter
        @EnumValue
        private final int code;
    }

    public boolean isStatusOK() {
        return status == Status.PUBLISHED;
    }

    // === 添加getter方法确保空值安全 ===
    public Integer getLeechers() {
        return leechers != null ? leechers : 0;
    }

    public Integer getSeeders() {
        return seeders != null ? seeders : 0;
    }
}