package com.ruoyi.web.domain.BT;


import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

@Data
@Schema(description = "TOTP")
public class TotpVo {

    @NotEmpty
    @Schema(description = "密钥")
    String key;

    @Schema(description = "二维码内容")
    String uri;


    @NotNull
    @Length(min = 6, max = 6)
    @Schema(description = "6位动态验证码")
    Integer code;
}
