package com.ruoyi.web.controller.BT;

import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.entity.SysUser;

import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.web.Server.BT.TorrentCommentService;
import com.ruoyi.web.Server.BT.TorrentService;
import com.ruoyi.web.Server.BT.TrackerURLService;
import com.ruoyi.web.Server.sys.UserCredentialService;
import com.ruoyi.web.Server.sys.UserService;
import com.ruoyi.web.controller.common.base.ResPage;
import com.ruoyi.web.dao.BT.SuggestDao;
import com.ruoyi.web.dao.BT.TagDao;
import com.ruoyi.web.dao.BT.TorrentDao;
import com.ruoyi.web.domain.BT.*;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.multipart;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

import com.ruoyi.web.controller.common.base.PageUtil;


import static org.mockito.ArgumentMatchers.*;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class) // 使用 Mockito 扩展
class TorrentControllerTest {

    @Mock // 模拟依赖的 DAO
    private TagDao tagDao;
    @Mock // 模拟依赖的 DAO
    private TorrentDao torrentDao;

    @Mock // 模拟依赖的 Service
    private SuggestDao suggestDao;

    @Mock
    private TorrentService torrentService;

    @Mock
    private TorrentCommentService torrentCommentService;

    @Mock
    private UserService userService;

    @Mock
    private TrackerURLService trackerURLService;

    @Mock
    private UserCredentialService userCredentialService;

    @Mock
    private PageUtil pageUtil;

    @InjectMocks // 注入被测试的 Controller
    private TorrentController torrentController;

    private MockMvc mockMvc;
    private ObjectMapper objectMapper;

    @BeforeEach
    void setUp() {

        // 创建 LoginUser 实例时使用 int 类型的 userId 和 deptId
        LoginUser loginUser = new LoginUser(
                1,
                1,
                new SysUser(),
                new HashSet<>()
        );

        mockMvc = MockMvcBuilders.standaloneSetup(torrentController).build();
        objectMapper = new ObjectMapper();
    }


    @Test
    void testSuggestWithoutKeyword() throws Exception {
        // 执行请求（q参数为空）
        mockMvc.perform(get("/torrent/suggest"))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$.data").isArray())
                .andExpect(jsonPath("$.data").isEmpty());
    }

    @Test
    void testAudit() throws Exception {
        TorrentAuditParam param = new TorrentAuditParam();
        param.setId(1);
        param.setStatus(1);
        mockMvc.perform(post("/torrent/audit")
                        .contentType(MediaType.APPLICATION_JSON)
                        .content(objectMapper.writeValueAsString(param)))
                .andExpect(status().isOk());
        verify(torrentService, times(1)).audit(param);
    }


    @Test
    void testCreateCredential() throws Exception {
        mockMvc.perform(post("/torrent/create_credential"))
                .andExpect(status().isOk());
        verify(torrentService, times(1)).createCredential(Math.toIntExact(0)); // 假设用户ID为1
    }

    @Test
    void testUpdate() throws Exception {
        TorrentEntity entity = new TorrentEntity();
        entity.setId(1);
        entity.setTitle("Updated");
        entity.setStatus(1);
        mockMvc.perform(post("/torrent/update")
                        .contentType(MediaType.APPLICATION_JSON)
                        .content(objectMapper.writeValueAsString(entity)))
                .andExpect(status().isOk());
        verify(torrentService, times(1)).update(entity);
    }

    @Test
    void testDelete() throws Exception {
        mockMvc.perform(post("/torrent/delete")
                        .contentType(MediaType.APPLICATION_JSON)
                        .content(objectMapper.writeValueAsString(new Integer[]{1, 2})))
                .andExpect(status().isOk());
        verify(torrentService, times(1)).remove(any(Integer[].class));
    }

    @Test
    void testTracker() throws Exception {
        when(trackerURLService.getAnnounce(anyString())).thenReturn("http://tracker.test/announce");
        when(userService.getPasskey(Math.toIntExact(0))).thenReturn("test-passkey");

        mockMvc.perform(post("/torrent/tracker"))
                .andExpect(jsonPath("$.data").value("http://tracker.test/announce"));
    }

    @Test
    void testDownload() throws Exception {
        TorrentEntity entity = new TorrentEntity();
        entity.setId(1);
        entity.setFilename("test.torrent");
        when(torrentService.getById(1)).thenReturn(entity);
        when(torrentService.fetch(1, null)).thenReturn("torrent-bytes".getBytes());

        mockMvc.perform(get("/torrent/download")
                        .param("id", "1"))
                .andExpect(status().isOk());
        verify(torrentService, times(1)).incrementLeechers(1);
    }

}