// BountyControllerTest.java
package com.ruoyi.web.controller.bounty;

import bounty.controller.BountyController;
import bounty.domain.Bounty;
import bounty.service.BountyService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.domain.model.LoginUser;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.WebMvcTest;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import static org.mockito.ArgumentMatchers.*;
import static org.mockito.Mockito.*;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.*;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;
@ExtendWith(MockitoExtension.class)
class BountyControllerTest {

    @Mock
    private BountyService bountyService;

    @InjectMocks
    private BountyController bountyController;

    private MockMvc mockMvc;
    private ObjectMapper objectMapper;

    @BeforeEach
    void setUp() {
        // 移除手动创建的SecurityContext，使用Spring Security测试支持
        mockMvc = MockMvcBuilders.standaloneSetup(bountyController).build();
        objectMapper = new ObjectMapper();
    }

    @Test
    void testSaveBountySuccess() throws Exception {
        Bounty bounty = new Bounty();
        bounty.setTitle("测试悬赏");

        when(bountyService.saveBounty(any(Bounty.class))).thenReturn(true);

        mockMvc.perform(post("/bounties")
                        .contentType(MediaType.APPLICATION_JSON)
                        .content(objectMapper.writeValueAsString(bounty)))
                .andExpect(status().isOk());

        verify(bountyService, times(1)).saveBounty(any(Bounty.class));
    }

    @Test
    void testSaveBountyFailure() throws Exception {
        Bounty bounty = new Bounty();
        bounty.setTitle("测试悬赏");

        when(bountyService.saveBounty(any(Bounty.class))).thenReturn(false);

        mockMvc.perform(post("/bounties")
                        .contentType(MediaType.APPLICATION_JSON)
                        .content(objectMapper.writeValueAsString(bounty)))
                .andExpect(status().isInternalServerError());

        verify(bountyService, times(1)).saveBounty(any(Bounty.class));
    }

    @Test
    void testGetBounties() throws Exception {
        List<Bounty> bounties = new ArrayList<>();
        when(bountyService.getBounties()).thenReturn(bounties);

        mockMvc.perform(get("/bounties"))
                .andExpect(status().isOk());

        verify(bountyService, times(1)).getBounties();
    }

    @Test
    void testGetBountyById() throws Exception {
        Bounty bounty = new Bounty();
        bounty.setId(1L);
        bounty.setTitle("测试悬赏");

        when(bountyService.getBountyById(1L)).thenReturn(bounty);

        mockMvc.perform(get("/bounties/1"))
                .andExpect(status().isOk());

        verify(bountyService, times(1)).getBountyById(1L);
    }

    @Test
    void testGetNonExistentBounty() throws Exception {
        when(bountyService.getBountyById(999L)).thenReturn(null);

        mockMvc.perform(get("/bounties/999"))
                .andExpect(status().isNotFound());

        verify(bountyService, times(1)).getBountyById(999L);
    }

    @Test
    void testPublishBountySuccess() throws Exception {
        Bounty bounty = new Bounty();
        bounty.setTitle("发布测试");

        when(bountyService.publishBounty(any(Bounty.class))).thenReturn(true);

        mockMvc.perform(post("/bounties/publish")
                        .contentType(MediaType.APPLICATION_JSON)
                        .content(objectMapper.writeValueAsString(bounty)))
                .andExpect(status().isOk());

        verify(bountyService, times(1)).publishBounty(any(Bounty.class));
    }
}
