package bounty.service;

import bounty.domain.Bounty;
import bounty.mapper.BountyMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.SecurityUtils; // 导入 Ruoyi 安全工具类
import org.springframework.stereotype.Service;
import java.util.List;

@Service
public class BountyServiceImpl extends ServiceImpl<BountyMapper, Bounty> implements BountyService {
    @Override
    public boolean saveBounty(Bounty bounty) {
        return this.save(bounty);
    }

    @Override
    public IPage<Bounty> getBountiesByPage(Page<Bounty> page) {
        QueryWrapper<Bounty> wrapper = new QueryWrapper<>();
        return this.page(page, wrapper);
    }

    @Override
    public Bounty getBountyById(Long id) {
        return this.getById(id);
    }

    @Override
    public boolean publishBounty(Bounty bounty) {
        // 校验标题不能为空
        if (bounty.getTitle() == null || bounty.getTitle().trim().isEmpty()) {
            throw new IllegalArgumentException("悬赏标题不能为空");
        }

        // 获取当前用户 ID 并设置到 Bounty 对象
        Long currentUserId = SecurityUtils.getUserId(); // 使用 Ruoyi 工具类获取用户 ID
        bounty.setCreator_id(currentUserId); // 设置 creator_id（需与实体类字段名一致）
        // 设置默认状态（假设 1 为已发布）
        bounty.setStatus(1);
        return this.save(bounty);
    }


    @Override
    public List<Bounty> getBounties() {
    // 直接调用 MyBatis-Plus 的 list 方法查询所有数据（可根据需求添加查询条件）
        return baseMapper.selectList();  // null 表示无查询条件，查询所有
    }

}