package com.ruoyi.web.Server.BT;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.web.Server.sys.UserService;
import com.ruoyi.web.dao.BT.TorrentCommentDao;
import com.ruoyi.web.dao.BT.TorrentPeerDao;
import com.ruoyi.web.domain.BT.TorrentCommentEntity;

import com.ruoyi.web.domain.BT.TorrentCommentVO;
import com.ruoyi.web.domain.sys.UserEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
@Slf4j
@RequiredArgsConstructor
public class TorrentCommentService extends ServiceImpl<TorrentCommentDao, TorrentCommentEntity> {

    private final TorrentCommentDao torrentCommentDao;
    private final UserService userService;

    public boolean saveComment(TorrentCommentEntity entity){
        return save(entity);
    }


    public PageInfo<TorrentCommentVO> getCommentsByTorrentId(
            Integer torrentId, Integer pageNum, Integer pageSize) {
        // 分页查询
        PageHelper.startPage(pageNum, pageSize);
        List<TorrentCommentEntity> commentEntities =
                torrentCommentDao.selectByTorrentId(torrentId);

        // 转换为VO（包含用户信息）
        List<TorrentCommentVO> commentVOs = commentEntities.stream()
                .map(entity -> {
                    TorrentCommentVO vo = new TorrentCommentVO();
                    BeanUtils.copyProperties(entity, vo);

                    // 查询用户信息
                    UserEntity user = userService.getUserById(entity.getUserId());
                    if (user != null) {
                        vo.setUsername(user.getUserName());
                        vo.setAvatar(user.getAvatar());
                    }

                    // 递归查询子评论（楼中楼）
                    List<TorrentCommentVO> children = getChildrenComments(entity.getId());
                    vo.setChildren(children);

                    return vo;
                })
                .collect(Collectors.toList());

        return new PageInfo<>(commentVOs);
    }

    // 递归查询子评论
    private List<TorrentCommentVO> getChildrenComments(Integer parentId) {
        List<TorrentCommentEntity> children =
                torrentCommentDao.selectByParentId(parentId);

        return children.stream()
                .map(entity -> {
                    TorrentCommentVO vo = new TorrentCommentVO();
                    BeanUtils.copyProperties(entity, vo);

                    // 设置用户信息
                    UserEntity user = userService.getUserById(entity.getUserId());
                    if (user != null) {
                        vo.setUsername(user.getUserName());
                        vo.setAvatar(user.getAvatar());
                    }

                    return vo;
                })
                .collect(Collectors.toList());
    }

}
