package com.ruoyi.web.Server.planet;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.file.FileUploadUtils;
import com.ruoyi.web.domain.planet.Planet;
import com.ruoyi.web.domain.planet.UserPlanet;
import com.ruoyi.web.mapper.planet.PlanetMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

@Service
public class PlanetServiceImpl extends ServiceImpl<PlanetMapper, Planet> implements IPlanetService {
    @Autowired
    private PlanetMapper planetMapper;

    @Override
    public List<Planet> getPlanetList(Long pageNum, Long pageSize) {
        System.out.println("########################");
        return planetMapper.selectPlanetList((pageNum-1)*pageSize, pageSize);
    }

    @Override
    public List<UserPlanet> getUserPlanetList() {
        return planetMapper.selectUserPlanetList();
    }

    @Override
    public Planet getPlanetById(Long id) {
        return planetMapper.selectPlanetById(id);
    }

    @Override
    public Planet uploadPlanetFile(MultipartFile file) {
        String fileName = null;
        try {
            fileName = FileUploadUtils.upload(file);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        Planet planet = new Planet();
        planet.setName(fileName);
        planet.setFilename(fileName);
        planet.setCreateTime(DateUtils.getNowDate());
        planetMapper.insertPlanet(planet);
        return planet;
    }

    @Override
    public void updatePlanet(Planet planet) {
        planetMapper.updatePlanet(planet);
    }

    @Override
    public void updateUserPlanet(UserPlanet userPlanet) {
        planetMapper.updateUserPlanet(userPlanet);
    }

    @Override
    public void deletePlanets(List<Long> ids) {
        planetMapper.deletePlanetsByIds(ids);
    }

    @Override
    public UserPlanet getUserPlanetByUserId(Long userId) {
        return planetMapper.selectUserPlanetByUserId(userId);
    }
}
