package com.ruoyi.web.controller.post.mapper;

import java.util.List;

import com.ruoyi.web.controller.post.domain.PostComment;

/**
 * 帖子评论Mapper接口
 * 
 * @author thunderhub
 */
public interface PostCommentMapper 
{
    /**
     * 查询帖子评论信息
     * 
     * @param commentId 帖子评论ID
     * @return 帖子评论信息
     */
    public PostComment selectPostCommentById(Long commentId);

    /**
     * 查询帖子评论列表
     * 
     * @param postComment 帖子评论信息
     * @return 帖子评论集合
     */
    public List<PostComment> selectPostCommentList(PostComment postComment);

    /**
     * 根据帖子ID查询评论
     * 
     * @param postId 帖子ID
     * @param limit 查询数量，0表示查询全部
     * @return 帖子评论集合
     */
    public List<PostComment> selectCommentsByPostId(Long postId, int limit);

    /**
     * 根据父评论ID查询回复
     * 
     * @param parentId 父评论ID
     * @return 帖子评论集合
     */
    public List<PostComment> selectCommentsByParentId(Long parentId);

    /**
     * 新增帖子评论
     * 
     * @param postComment 帖子评论信息
     * @return 结果
     */
    public int insertPostComment(PostComment postComment);

    /**
     * 修改帖子评论
     * 
     * @param postComment 帖子评论信息
     * @return 结果
     */
    public int updatePostComment(PostComment postComment);

    /**
     * 删除帖子评论
     * 
     * @param commentId 帖子评论ID
     * @return 结果
     */
    public int deletePostCommentById(Long commentId);

    /**
     * 批量删除帖子评论
     * 
     * @param commentIds 需要删除的帖子评论ID
     * @return 结果
     */
    public int deletePostCommentByIds(Long[] commentIds);

    /**
     * 根据帖子ID删除评论
     * 
     * @param postId 帖子ID
     * @return 结果
     */
    public int deletePostCommentByPostId(Long postId);

    /**
     * 更新评论点赞数
     * 
     * @param postComment 评论信息
     * @return 结果
     */
    public int updateCommentLikes(PostComment postComment);
} 