package com.ruoyi.web.controller.post.service;

import java.util.List;

import com.ruoyi.web.controller.post.domain.PostFavorite;

/**
 * 帖子收藏 服务层
 * 
 * @author thunderhub
 */
public interface IPostFavoriteService 
{
    /**
     * 查询帖子收藏信息
     * 
     * @param favoriteId 帖子收藏ID
     * @return 帖子收藏信息
     */
    public PostFavorite selectPostFavoriteById(Long favoriteId);

    /**
     * 查询帖子收藏列表
     * 
     * @param postFavorite 帖子收藏信息
     * @return 帖子收藏集合
     */
    public List<PostFavorite> selectPostFavoriteList(PostFavorite postFavorite);

    /**
     * 查询用户是否收藏帖子
     * 
     * @param postId 帖子ID
     * @param userId 用户ID
     * @return 收藏信息
     */
    public PostFavorite selectPostFavoriteByPostIdAndUserId(Long postId, Long userId);

    /**
     * 新增帖子收藏
     * 
     * @param postFavorite 帖子收藏信息
     * @return 结果
     */
    public int insertPostFavorite(PostFavorite postFavorite);

    /**
     * 修改帖子收藏
     * 
     * @param postFavorite 帖子收藏信息
     * @return 结果
     */
    public int updatePostFavorite(PostFavorite postFavorite);

    /**
     * 删除帖子收藏信息
     * 
     * @param favoriteId 帖子收藏ID
     * @return 结果
     */
    public int deletePostFavoriteById(Long favoriteId);

    /**
     * 批量删除帖子收藏信息
     * 
     * @param favoriteIds 需要删除的帖子收藏ID
     * @return 结果
     */
    public int deletePostFavoriteByIds(Long[] favoriteIds);

    /**
     * 取消收藏帖子
     * 
     * @param postId 帖子ID
     * @param userId 用户ID
     * @return 结果
     */
    public int cancelPostFavorite(Long postId, Long userId);

    /**
     * 根据帖子ID删除收藏
     * 
     * @param postId 帖子ID
     * @return 结果
     */
    public int deletePostFavoriteByPostId(Long postId);

    /**
     * 根据用户ID查询收藏列表
     * 
     * @param userId 用户ID
     * @return 收藏列表
     */
    public List<PostFavorite> selectPostFavoritesByUserId(Long userId);
} 